% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmsfp_mm.r
\name{nmsfp_mm}
\alias{nmsfp_mm}
\title{MM algorithm for nonlinear multiple-sets split feasibility problem}
\usage{
nmsfp_mm(x0, v, w, plist1, plist2, f, df, h, hgrad, tol = 1e-10,
  max_iter = 1000)
}
\arguments{
\item{x0}{Initial iterate}

\item{v}{weights for first set of constraints}

\item{w}{weights for second set of constraints}

\item{plist1}{list of projection functions for first set of constraints; each takes a single point and returns its projection}

\item{plist2}{list of projection functions for second set of constraints; each takes a single point and returns its projection}

\item{f}{objective function}

\item{df}{gradient of objective function}

\item{h}{Function handle for output mapping}

\item{hgrad}{Handle for output mapping Jacobian}

\item{tol}{Stopping tolerance}

\item{max_iter}{Maximum number of iterations}
}
\description{
\code{nmsfp_mm} uses quasi-Newton updates to solve the nonlinear multiple-sets split feasibility problem.
}
\seealso{
\code{mmqn_step}
}
