% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.r
\name{play_tour_path}
\alias{play_tour_path}
\title{Render display of a provided tour path}
\usage{
play_tour_path(tour_path, data = NULL, angle = 0.05,
  render_type = render_plotly, col = "black", pch = 20,
  axes = "center", fps = 3, ...)
}
\arguments{
\item{tour_path}{The result of \code{tourr::save_history()} or \code{manual_tour()}.}

\item{data}{Optional, number of columns must match that of \code{tour_path}.}

\item{angle}{target distance (in radians) between bases.}

\item{render_type}{Which graphics to render to. Defaults to render_plotly,
alternative use render_gganimate.}

\item{col}{Color of the projected points. Defaults to "black".}

\item{pch}{Point character of the projected points. Defaults to 20.}

\item{axes}{Position of the axes: "center", "bottomleft" or "off". Defaults
to "center".}

\item{fps}{Frames/slides shown per second. Defaults to 3.}

\item{...}{Optionally pass additional arguments to \code{render_type}.}
}
\description{
Takes the result of \code{tourr::save_history()} or \code{manual_tour()}, interpolates
over the path and renders into a selected \code{render_type}.
}
\examples{
\dontrun{
flea_std <- rescale(tourr::flea[,1:6])
tpath    <- save_history(flea_std, max = 3)

play_tour_path(tour_path = tpath, data = flea_std, angle = .15)

play_tour_path(tour_path = tpath, data = flea_std, angle = .15, fps = 4,
  render_type = render_gganimate, col = col_of(flea$species), axes = "bottomleft")
}
}
