% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unif-alts.R
\name{Sobolev_coefs}
\alias{Sobolev_coefs}
\alias{bk_to_vk2}
\alias{bk_to_uk}
\alias{vk2_to_bk}
\alias{vk2_to_uk}
\alias{uk_to_vk2}
\alias{uk_to_bk}
\title{Transformation between different coefficients in Sobolev statistics}
\usage{
bk_to_vk2(bk, p, log = FALSE)

bk_to_uk(bk, p, signs = 1)

vk2_to_bk(vk2, p, log = FALSE)

vk2_to_uk(vk2, p, signs = 1)

uk_to_vk2(uk, p)

uk_to_bk(uk, p)
}
\arguments{
\item{bk}{coefficients \eqn{b_{k, p}} associated to the indexes
\code{1:length(bk)}, a vector.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{log}{do operations in log scale (log-in, log-out)? Defaults to
\code{FALSE}.}

\item{signs}{signs of the coefficients \eqn{u_{k, p}}, a vector of the
same size as \code{vk2} or \code{bk}, or a scalar. Defaults to \code{1}.}

\item{vk2}{\bold{squared} coefficients \eqn{v_{k, p}^2} associated to the
indexes \code{1:length(vk2)}, a vector.}

\item{uk}{coefficients \eqn{u_{k, p}} associated to the indexes
\code{1:length(uk)}, a vector.}
}
\value{
The corresponding vectors of coefficients \code{vk2}, \code{bk}, or
\code{uk}, depending on the call.
}
\description{
Given a Sobolev statistic
\deqn{S_{n, p} = \sum_{i, j = 1}^n \psi(\cos^{-1}({\bf X}_i'{\bf X}_j)),}{
S_{n, p} = \sum_{i, j = 1}^n \psi(\cos^{-1}(X_i'X_j)),}
for a sample \eqn{{\bf X}_1, \ldots, {\bf X}_n \in S^{p - 1} := \{{\bf x}
\in R^p : ||{\bf x}|| = 1\}}{X_1, \ldots, X_n \in S^{p - 1} :=
\{x \in R^p : ||x|| = 1\}}, \eqn{p\ge 2}, three important sequences
are related to \eqn{S_{n, p}}.
\itemize{
\item \link[=Gegen_coefs]{Gegenbauer coefficients} \eqn{\{b_{k, p}\}} of
\eqn{\psi_p} (see, e.g., the \link[=Pn]{projected-ecdf statistics}), given
by
\deqn{b_{k, p} := \frac{1}{c_{k, p}}\int_0^\pi \psi_p(\theta)
C_k^{p / 2 - 1}(\cos\theta)\,\mathrm{d}\theta.}{
b_{k, p} := \frac{1}{c_{k, p}} \int_0^\pi \psi_p(\theta)
C_k^(p / 2 - 1)(\cos\theta) d\theta.}
\item Weights \eqn{\{v_{k, p}^2\}} of the
\link[=Sobolev]{asymptotic distribution} of the Sobolev statistic,
\eqn{\sum_{k = 1}^\infty v_k^2 \chi^2_{d_{p, k}}}, given by
\deqn{v_{k, p}^2 = \left(1 + \frac{2k}{p - 2}\right)^{-1} b_{k, p},
\quad p \ge 3.}{v_{k, p}^2 = (1 + 2k / (p - 2))^{-1} b_{k, p}, p \ge 3.}
\item Gegenbauer coefficients \eqn{\{u_{k, p}\}} of the
\link[=locdev]{local projected alternative} associated to \eqn{S_{n, p}},
given by
\deqn{u_{k, p} = \left(1 + \frac{2k}{p - 2}\right) v_{k, p},
\quad p \ge 3.}{u_{k, p} = (1 + 2k / (p - 2)) b_{k, p}, p \ge 3.}
}
For \eqn{p = 2}, the factor \eqn{(1 + 2k / (p - 2))} is replaced by \eqn{2}.
}
\details{
See more details in Prentice (1978) and García-Portugués et al. (2023). The
adequate signs of \code{uk} for the \code{"PRt"} \link[=Pn]{Rothman test}
can be retrieved with \code{\link{akx}} and \code{sqr = TRUE}, see the
examples.
}
\examples{
# bk, vk2, and uk for the PCvM test in p = 3
(bk <- Gegen_coefs_Pn(k = 1:5, type = "PCvM", p = 3))
(vk2 <- bk_to_vk2(bk = bk, p = 3))
(uk <- bk_to_uk(bk = bk, p = 3))

# vk2 is the same as
weights_dfs_Sobolev(K_max = 10, thre = 0, p = 3, type = "PCvM")$weights

# bk and uk for the Rothman test in p = 3, with adequate signs
t <- 1 / 3
(bk <- Gegen_coefs_Pn(k = 1:5, type = "PRt", p = 3, Rothman_t = t))
(ak <- akx(x = drop(q_proj_unif(t, p = 3)), p = 3, k = 1:5, sqr = TRUE))
(uk <- bk_to_uk(bk = bk, p = 3, signs = ak))
}
\references{
García-Portugués, E., Navarro-Esteban, P., Cuesta-Albertos, J. A. (2023)
On a projection-based class of uniformity tests on the hypersphere.
\emph{Bernoulli}, 29(1):181--204. \doi{10.3150/21-BEJ1454}.

Prentice, M. J. (1978). On invariant tests of uniformity for directions and
orientations. \emph{The Annals of Statistics}, 6(1):169--176.
\doi{10.1214/aos/1176344075}
}
