% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ecdf_bin}
\alias{ecdf_bin}
\title{Efficient evaluation of the empirical cumulative distribution
function}
\usage{
ecdf_bin(data, sorted_x, data_sorted = FALSE, efic = TRUE, divide_n = TRUE)
}
\arguments{
\item{data}{a vector or column matrix containing the sample.}

\item{sorted_x}{a vector or column matrix with the evaluation points
\bold{sorted increasingly}.}

\item{data_sorted}{is \code{data} is already sorted increasingly?
This avoids sorting the data internally.}

\item{efic}{use the more efficient version of the ecdf evaluation? Set to
\code{FALSE} only for debugging purposes.}

\item{divide_n}{if \code{FALSE}, returns the absolute frequencies instead
of the relative frequencies. Defaults to \code{TRUE}.}
}
\value{
The ecdf evaluated at \code{sorted_x}.
}
\description{
Evaluates the empirical cumulative distribution function
(ecdf) of a sample \code{data} at the evaluation points \code{sorted_x}.
This is done through binary search.
}
\section{Warning}{

Be careful on avoiding the next bad usages of the function, which will
produce spurious results:
\itemize{
  \item \code{sorted_x} is not sorted increasingly.
  \item \code{data} is not sorted increasingly when
  \code{data_sorted = TRUE}-
}
}

\author{
Original code from Douglas Bates'
\url{https://github.com/dmbates/ecdfExample}. Minor adaptations by Eduardo
García-Portugués.
}
\keyword{internal}
