% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diags.R
\name{plot_pop_totals}
\alias{plot_pop_totals}
\title{Plot characteristic summary output from summarize_top_spew_region as totals}
\usage{
plot_pop_totals(feature_df, type = "n_people", text_size = 10,
  region_colors = c("#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442",
  "#0072B2", "#D55E00", "#CC79A7"))
}
\arguments{
\item{feature_df}{features summary, output from summarize_top_region()}

\item{type}{either "n_house" or "n_people".  Default is n_people}

\item{text_size}{axis text size.  Default is 10}

\item{region_colors}{a string of colors to color the map.  Default is from the colorblind friendly palette.}
}
\value{
a gg map object
}
\description{
Plot characteristic summary output from summarize_top_spew_region as totals
}
\examples{
data(tartanville)

tartanville_syneco <- spew(tartanville$pop_table, tartanville$shapefile, 
                           tartanville$pums_h, tartanville$pums_p)
plot_syneco(tartanville, tartanville_syneco, region_name = "Tartanville")
}
