/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceFactory;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceStorage {
    private Map<Path, PreferenceFactory<?>> factories = new HashMap();
    private Node root = new Node(null);

    public static void write(PreferenceModel model, DataOutputStream out) throws IOException {
        PreferenceStorage storage = new PreferenceStorage();
        storage.store(model);
        storage.write(out);
    }

    public static void read(PreferenceModel model, DataInputStream in) throws IOException {
        PreferenceStorage storage = new PreferenceStorage();
        storage.read(in);
        storage.load(model, true);
    }

    public static void writeXML(PreferenceModel model, XElement element) {
        PreferenceStorage storage = new PreferenceStorage();
        storage.store(model);
        storage.writeXML(element);
    }

    public static void readXML(PreferenceModel model, XElement element) {
        PreferenceStorage storage = new PreferenceStorage();
        storage.readXML(element);
        storage.load(model, true);
    }

    public PreferenceStorage() {
        this.addFactory(Path.TYPE_INT_PATH, PreferenceFactory.FACTORY_INT);
        this.addFactory(Path.TYPE_STRING_PATH, PreferenceFactory.FACTORY_STRING);
        this.addFactory(Path.TYPE_BOOLEAN_PATH, PreferenceFactory.FACTORY_BOOLEAN);
        this.addFactory(Path.TYPE_KEYSTROKE_PATH, PreferenceFactory.FACTORY_KEYSTROKE);
        this.addFactory(Path.TYPE_MODIFIER_MASK_PATH, PreferenceFactory.FACTORY_MODIFIER_MASK);
        this.addFactory(Path.TYPE_STRING_CHOICE_PATH, PreferenceFactory.FACTORY_STRING);
    }

    public void addFactory(Path type, PreferenceFactory<?> factory) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        if (type.getSegmentCount() == 0) {
            throw new IllegalArgumentException("the root path is not a valid path for this metho");
        }
        this.factories.put(type, factory);
    }

    public void store(PreferenceModel model) {
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            if (model.isNatural(i)) continue;
            Node node = this.root.getNode(model.getPath(i), true);
            node.put(model.getTypePath(i), model.getValue(i));
        }
    }

    public void load(PreferenceModel model, boolean missingToNull) {
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            if (!model.isNatural(i)) {
                Node node = this.root.getNode(model.getPath(i), false);
                if (node == null) {
                    if (!missingToNull) continue;
                    model.setValue(i, null);
                    continue;
                }
                model.setValue(i, node.value);
                continue;
            }
            model.setValueNatural(i);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        Version.write(out, Version.CURRENT);
        this.write(this.root, out);
    }

    private void write(Node node, DataOutputStream out) throws IOException {
        Path type = node.getType();
        if (type == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(type.toString());
            Object value = node.getValue();
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                PreferenceFactory<?> factory = this.factories.get(type);
                if (factory == null) {
                    throw new IOException("unknown path for a type: " + type);
                }
                factory.write(value, out);
            }
        }
        int size = node.getChildrenCount();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Node child = node.getChild(i);
            out.writeUTF(child.getName());
            this.write(child, out);
        }
    }

    public void read(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        this.read(this.root, in);
    }

    private void read(Node node, DataInputStream in) throws IOException {
        Path type = null;
        Object value = null;
        if (in.readBoolean()) {
            type = new Path(in.readUTF());
            if (in.readBoolean()) {
                PreferenceFactory<?> factory = this.factories.get(type);
                if (factory == null) {
                    throw new IOException("don't know how to read objects of type " + type);
                }
                value = factory.read(in);
            }
        }
        node.put(type, value);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            Node child = node.getNode(new Path(name), true);
            this.read(child, in);
        }
    }

    public void writeXML(XElement element) {
        this.writeXML(this.root, element);
    }

    private void writeXML(Node node, XElement element) {
        PreferenceFactory<?> factory;
        Path type = node.getType();
        Object value = node.getValue();
        if (type != null && value != null && (factory = this.factories.get(type)) != null) {
            XElement xvalue = element.addElement("value");
            xvalue.addString("type", type.toString());
            factory.writeXML(value, xvalue);
        }
        int size = node.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            Node child = node.getChild(i);
            XElement xchild = element.addElement("child");
            xchild.addString("name", child.getName());
            this.writeXML(child, xchild);
        }
    }

    public void readXML(XElement element) {
        this.readXML(this.root, element);
    }

    private void readXML(Node node, XElement element) {
        XElement[] xchildren;
        String typeName;
        PreferenceFactory<?> factory;
        Path type = null;
        Object value = null;
        XElement xvalue = element.getElement("value");
        if (xvalue != null && (factory = this.factories.get(type = new Path(typeName = xvalue.getString("type")))) != null) {
            value = factory.readXML(xvalue);
        }
        node.put(type, value);
        for (XElement xchild : xchildren = element.getElements("child")) {
            String name = xchild.getString("name");
            Node child = node.getNode(new Path(name), true);
            this.readXML(child, xchild);
        }
    }

    public void clear() {
        this.root = new Node(null);
    }

    private static class Node {
        private String name;
        private Object value;
        private Path type;
        private List<Node> children;

        public Node(String name) {
            this.name = name;
        }

        public void put(Path type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Path getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public int getChildrenCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        public String getName() {
            return this.name;
        }

        public Node getNode(Path path, boolean create) {
            return this.getNode(path, create, 0);
        }

        private Node getNode(Path path, boolean create, int segment) {
            if (path.getSegmentCount() == segment) {
                return this;
            }
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            String name = path.getSegment(segment);
            for (Node child : this.children) {
                if (!name.equals(child.getName())) continue;
                return child.getNode(path, create, segment + 1);
            }
            if (!create) {
                return null;
            }
            Node result = new Node(name);
            this.children.add(result);
            return result.getNode(path, create, segment + 1);
        }
    }
}

