/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.BackupFactoryData;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteringDockFactory<D extends Dockable, P extends PerspectiveDockable, L>
implements DockFactory<D, P, BackupFactoryData<L>> {
    private DockFrontend frontend;
    private DockFactory<D, P, L> factory;

    public RegisteringDockFactory(DockFrontend frontend, DockFactory<D, P, L> factory) {
        this.frontend = frontend;
        this.factory = factory;
    }

    @Override
    public String getID() {
        return this.factory.getID();
    }

    @Override
    public void estimateLocations(BackupFactoryData<L> layout, LocationEstimationMap children) {
        this.factory.estimateLocations(layout.getData(), children);
    }

    @Override
    public BackupFactoryData<L> getLayout(D element, Map<Dockable, Integer> children) {
        return new BackupFactoryData(null, this.factory.getLayout(element, children));
    }

    @Override
    public D layout(BackupFactoryData<L> layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        String id;
        Dockable element = (Dockable)this.factory.layout(layout.getData(), placeholders);
        if (element != null && (id = layout.getIdentifier()).startsWith("dockable") && this.frontend.getDockable(id = id.substring("dockable".length())) == null) {
            this.frontend.addDockable(id, element);
        }
        return (D)element;
    }

    @Override
    public D layout(BackupFactoryData<L> layout, PlaceholderStrategy placeholders) {
        String id;
        Dockable element = (Dockable)this.factory.layout(layout.getData(), placeholders);
        if (element != null && (id = layout.getIdentifier()).startsWith("dockable") && this.frontend.getDockable(id = id.substring("dockable".length())) == null) {
            this.frontend.addDockable(id, element);
        }
        return (D)element;
    }

    @Override
    public BackupFactoryData<L> read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        return new BackupFactoryData(null, this.factory.read(in, placeholders));
    }

    @Override
    public BackupFactoryData<L> read(XElement element, PlaceholderStrategy placeholders) {
        return new BackupFactoryData(null, this.factory.read(element, placeholders));
    }

    @Override
    public void setLayout(D element, BackupFactoryData<L> layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        this.factory.setLayout(element, layout.getData(), children, placeholders);
    }

    @Override
    public void setLayout(D element, BackupFactoryData<L> layout, PlaceholderStrategy placeholders) {
        this.factory.setLayout(element, layout.getData(), placeholders);
    }

    @Override
    public void write(BackupFactoryData<L> layout, DataOutputStream out) throws IOException {
        this.factory.write(layout.getData(), out);
    }

    @Override
    public void write(BackupFactoryData<L> layout, XElement element) {
        this.factory.write(layout.getData(), element);
    }

    @Override
    public BackupFactoryData<L> getPerspectiveLayout(P element, Map<PerspectiveDockable, Integer> children) {
        return new BackupFactoryData<L>(null, this.factory.getPerspectiveLayout(element, children));
    }

    @Override
    public P layoutPerspective(BackupFactoryData<L> layout, Map<Integer, PerspectiveDockable> children) {
        if (layout.getData() == null) {
            return null;
        }
        return (P)((PerspectiveDockable)this.factory.layoutPerspective(layout.getData(), children));
    }

    @Override
    public void layoutPerspective(P perspective, BackupFactoryData<L> layout, Map<Integer, PerspectiveDockable> children) {
        if (layout.getData() != null) {
            this.factory.layoutPerspective(perspective, layout.getData(), children);
        }
    }
}

