/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class ActionPopup
extends MouseInputAdapter {
    private boolean suppressable;
    private JPopupMenu menu;

    public ActionPopup(boolean suppressable) {
        this.suppressable = suppressable;
    }

    public boolean isSuppressable() {
        return this.suppressable;
    }

    public void setSuppressable(boolean suppressable) {
        this.suppressable = suppressable;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e);
        }
    }

    protected abstract boolean isEnabled();

    protected abstract Dockable getDockable();

    protected abstract DockActionSource getSource();

    protected void popup(MouseEvent e) {
        boolean shown;
        if (this.isMenuOpen()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (this.isEnabled() && (shown = this.popup(e.getComponent(), e.getX(), e.getY()))) {
            e.consume();
        }
    }

    protected Point getPopupLocation(Component owner, Point location) {
        return location;
    }

    public boolean popup(Component owner, int x, int y) {
        JPopupMenu methodMenu;
        Point location = this.getPopupLocation(owner, new Point(x, y));
        if (location == null) {
            return false;
        }
        Dockable dockable = this.getDockable();
        if (dockable.getController() == null) {
            return false;
        }
        if (dockable.getController().getRelocator().isOnMove()) {
            return false;
        }
        DockActionSource source = this.getSource();
        if (source.getDockActionCount() == 0) {
            return false;
        }
        if (this.isSuppressable() && dockable.getController().getPopupSuppressor().suppress(dockable, source)) {
            return false;
        }
        this.menu = methodMenu = new JPopupMenu();
        final MenuMenuHandler handler = new MenuMenuHandler(source, dockable, this.menu);
        handler.bind();
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        handler.unbind();
                        if (methodMenu == ActionPopup.this.menu) {
                            ActionPopup.this.menu = null;
                        }
                    }
                });
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.menu.show(owner, location.x, location.y);
        return true;
    }

    public boolean isMenuOpen() {
        return this.menu != null;
    }
}

