/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CExternalizedLocation;
import bibliothek.gui.dock.common.location.CFlapIndexLocation;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.common.location.CLocationExpandStrategy;
import bibliothek.gui.dock.common.location.CMaximalExternalizedLocation;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.common.location.CMinimizeAreaLocation;
import bibliothek.gui.dock.common.location.CWorkingAreaLocation;
import bibliothek.gui.dock.common.location.DefaultExpandStrategy;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;

public abstract class CLocation {
    public static CBaseLocation base(CContentArea center) {
        return new CBaseLocation(center);
    }

    public static CBaseLocation base() {
        return new CBaseLocation();
    }

    public static CWorkingAreaLocation working(CWorkingArea area) {
        return new CWorkingAreaLocation(area);
    }

    public static CMinimizeAreaLocation minimized(CMinimizeArea area) {
        return new CMinimizeAreaLocation(area);
    }

    public static CFlapIndexLocation minimized(CMinimizeArea area, int index) {
        return new CMinimizeAreaLocation(area).insert(index);
    }

    public static CGridAreaLocation normalized(CGridArea area) {
        return new CGridAreaLocation(area);
    }

    public static CExternalizedLocation external(int x, int y, int width, int height) {
        return new CExternalizedLocation(x, y, width, height);
    }

    public static CMaximizedLocation maximized() {
        return new CMaximizedLocation();
    }

    public static CMaximizedLocation maximized(CGridArea area) {
        return new CMaximizedLocation(area.getUniqueId());
    }

    public static CMaximizedLocation maximized(CContentArea area) {
        return new CMaximizedLocation(area.getCenterIdentifier());
    }

    public static CMaximalExternalizedLocation maximized(int x, int y, int width, int height) {
        return new CMaximalExternalizedLocation(x, y, width, height);
    }

    public abstract CLocation getParent();

    public abstract String findRoot();

    public abstract ExtendedMode findMode();

    public DockableProperty findProperty() {
        return this.findProperty(null);
    }

    public abstract DockableProperty findProperty(DockableProperty var1);

    public final CLocation expandProperty(DockableProperty property) {
        return this.expandProperty(property, new DefaultExpandStrategy());
    }

    public CLocation expandProperty(DockableProperty property, CLocationExpandStrategy strategy) {
        CLocation location = strategy.expand(this, property);
        if (location == null) {
            return null;
        }
        if ((property = property.getSuccessor()) == null) {
            return location;
        }
        return location.expandProperty(property, strategy);
    }

    public abstract CLocation aside();

    public boolean equals(Object obj) {
        if (obj instanceof CLocation) {
            CLocation that = (CLocation)obj;
            return this.equals(this.findRoot(), that.findRoot()) && this.equals(this.findMode(), that.findMode()) && this.equals(this.findProperty(), that.findProperty());
        }
        return false;
    }

    private boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        return a != null && a.equals(b);
    }

    public int hashCode() {
        String root = this.findRoot();
        ExtendedMode mode = this.findMode();
        DockableProperty property = this.findProperty();
        int result = 0;
        if (root != null) {
            result = root.hashCode();
        }
        result *= 31;
        if (mode != null) {
            result += ((Object)mode).hashCode();
        }
        result *= 31;
        if (property != null) {
            result += property.hashCode();
        }
        return result;
    }
}

