/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.intern.AbstractCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.station.ScreenResizeRequestHandler;
import bibliothek.gui.dock.common.location.CExternalizedLocation;
import bibliothek.gui.dock.common.mode.CExternalizedMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.station.CScreenDockStationHandle;
import bibliothek.gui.dock.common.perspective.CExternalizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.facile.station.screen.WindowProviderVisibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExternalizeArea
extends AbstractCStation<ScreenDockStation> {
    private ScreenResizeRequestHandler handler = new ScreenResizeRequestHandler((ScreenDockStation)this.getStation());
    private CScreenDockStationHandle handle;
    private WindowProviderVisibility visibility = new WindowProviderVisibility((ScreenDockStation)this.getStation());

    public CExternalizeArea(CControl control, String id) {
        this(control.getFactory().createScreenDockStation(control.getRootWindow()), id, CExternalizedLocation.STATION);
    }

    public CExternalizeArea(ScreenDockStation station, String id, CLocation location) {
        super(station, id, location);
        ((ScreenDockStation)this.getStation()).setShowing(false);
    }

    @Override
    protected void install(CControlAccess access) {
        access.getOwner().addResizeRequestListener(this.handler);
        this.visibility.setProvider(access.getOwner().getRootWindow());
        if (this.handle == null) {
            this.handle = new CScreenDockStationHandle(this, access.getLocationManager());
        }
        CExternalizedMode externalizedMode = access.getLocationManager().getExternalizedMode();
        CMaximizedMode maximizedMode = access.getLocationManager().getMaximizedMode();
        externalizedMode.add(this.handle.getExternalizedModeArea());
        if (externalizedMode.getDefaultArea() == null) {
            externalizedMode.setDefaultArea(this.handle.getExternalizedModeArea());
        }
        maximizedMode.add(this.handle.getMaximizedModeArea());
    }

    @Override
    protected void uninstall(CControlAccess access) {
        this.visibility.setProvider(null);
        ((ScreenDockStation)this.getStation()).setShowing(false);
        access.getOwner().removeResizeRequestListener(this.handler);
        access.getLocationManager().getExternalizedMode().remove(this.handle.getExternalizedModeArea().getUniqueId());
        access.getLocationManager().getMaximizedMode().remove(this.handle.getMaximizedModeArea().getUniqueId());
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CExternalizePerspective(this.getUniqueId());
    }
}

