% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speech_word_count.R
\name{speech_word_count}
\alias{speech_word_count}
\title{Number of words}
\usage{
speech_word_count(
  string,
  exclude = NULL,
  min.char = 0L,
  rm.long = Inf,
  rm.num = FALSE,
  replace.punct = ""
)
}
\arguments{
\item{string}{character of length equal to or greater than one.}

\item{exclude}{words that are to be excluded from counting.}

\item{min.char}{integer that determines the words that have less than a
certain number of characters.}

\item{rm.long}{integer that determines the number of characters from which
words have to be deleted from the count.}

\item{rm.num}{logical. Indicates whether the numbers in the count will be
eliminated.}

\item{replace.punct}{logical. If \code{TRUE} punctuation marks within a single
word will be replaced by a space. By default is \code{TRUE}.}
}
\value{
integer.
}
\description{
Word count.
}
\examples{
vec <- "Hello world!"
speech_word_count(vec)

vec2 <- "Hello.world!"
speech_word_count(vec2)
speech_word_count(vec2, replace.punct = " ")

vec3 <- "Hello.world!, HelloHelloHelloHelloHelloHello"
speech_word_count(vec3, replace.punct = " ", rm.long = 20)

speech_word_count("R version", min.char = 1)

r <- "R version 3.5.2 (2018-12-20) -- 'Eggshell Igloo'"
speech_word_count(r, rm.num = TRUE)

speech_word_count(NA)
}
