% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_function_overloads.R
\name{var.default}
\alias{var.default}
\title{Default variance}
\usage{
\method{var}{default}(x, y = NULL, na.rm = FALSE, use)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
    compatible dimensions to \code{x}.   The default is equivalent to
    \code{y = x} (but more efficient).}

\item{na.rm}{logical. Should missing values be removed?}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}
}
\value{
For \code{r <- cor(*, use = "all.obs")}, it is now guaranteed that
  \code{all(abs(r) <= 1)}.
}
\description{
Default variance
}
\details{
For \code{cov} and \code{cor} one must \emph{either} give a matrix or
  data frame for \code{x} \emph{or} give both \code{x} and \code{y}.

  The inputs must be numeric (as determined by \code{\link{is.numeric}}:
  logical values are also allowed for historical compatibility): the
  \code{"kendall"} and \code{"spearman"} methods make sense for ordered
  inputs but \code{\link{xtfrm}} can be used to find a suitable prior
  transformation to numbers.

  \code{var} is just another interface to \code{cov}, where
  \code{na.rm} is used to determine the default for \code{use} when that
  is unspecified.  If \code{na.rm} is \code{TRUE} then the complete
  observations (rows) are used (\code{use = "na.or.complete"}) to
  compute the variance.  Otherwise, by default \code{use = "everything"}.

  If \code{use} is \code{"everything"}, \code{\link{NA}}s will
  propagate conceptually, i.e., a resulting value will be \code{NA}
  whenever one of its contributing observations is \code{NA}.\cr
  If \code{use} is \code{"all.obs"}, then the presence of missing
  observations will produce an error.  If \code{use} is
  \code{"complete.obs"} then missing values are handled by casewise
  deletion (and if there are no complete cases, that gives an error).
  \cr
  \code{"na.or.complete"} is the same unless there are no complete
  cases, that gives \code{NA}.
  Finally, if \code{use} has the value \code{"pairwise.complete.obs"}
  then the correlation or covariance between each pair of variables is
  computed using all complete pairs of observations on those variables.
  This can result in covariance or correlation matrices which are not positive
  semi-definite, as well as \code{NA} entries if there are no complete
  pairs for that pair of variables.   For \code{cov} and \code{var},
  \code{"pairwise.complete.obs"} only works with the \code{"pearson"}
  method.
  Note that (the equivalent of) \code{var(double(0), use = *)} gives
  \code{NA} for \code{use = "everything"} and \code{"na.or.complete"},
  and gives an error in the other cases.

  The denominator \eqn{n - 1} is used which gives an unbiased estimator
  of the (co)variance for i.i.d. observations.
  These functions return \code{\link{NA}} when there is only one
  observation (whereas S-PLUS has been returning \code{NaN}), and
  fail if \code{x} has length zero.

  For \code{cor()}, if \code{method} is \code{"kendall"} or
  \code{"spearman"}, Kendall's \eqn{\tau}{tau} or Spearman's
  \eqn{\rho}{rho} statistic is used to estimate a rank-based measure of
  association.  These are more robust and have been recommended if the
  data do not necessarily come from a bivariate normal distribution.\cr
  For \code{cov()}, a non-Pearson method is unusual but available for
  the sake of completeness.  Note that \code{"spearman"} basically
  computes \code{cor(R(x), R(y))} (or \code{cov(., .)}) where \code{R(u)
  := rank(u, na.last = "keep")}. In the case of missing values, the
  ranks are calculated depending on the value of \code{use}, either
  based on complete observations, or based on pairwise completeness with
  reranking for each pair.

  When there are ties, Kendall's \eqn{\tau_b}{tau_b} is computed, as
  proposed by Kendall (1945).

  Scaling a covariance matrix into a correlation one can be achieved in
  many ways, mathematically most appealing by multiplication with a
  diagonal matrix from left and right, or more efficiently by using
  \code{\link{sweep}(.., FUN = "/")} twice.  The \code{cov2cor} function
  is even a bit more efficient, and provided mostly for didactical
  reasons.
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.

  Kendall, M. G. (1938)  A new measure of rank correlation,
  \emph{Biometrika} \bold{30}, 81--93. \url{https://dx.doi.org/10.1093/biomet/30.1-2.81}

  Kendall, M. G. (1945)  The treatment of ties in rank problems.
  \emph{Biometrika} \bold{33} 239--251. \url{https://dx.doi.org/10.1093/biomet/33.3.239}
}
\seealso{
\code{\link{cor.test}} for confidence intervals (and tests).

  \code{\link{cov.wt}} for \emph{weighted} covariance computation.

  \code{\link{sd}} for standard deviation (vectors).
}
