% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{smooth.spectra}
\alias{smooth.spectra}
\title{Smooth spectra}
\usage{
\method{smooth}{spectra}(x, method = "spline", ...)
}
\arguments{
\item{x}{spectra object. bands must be strictly increasing}

\item{method}{Choose smoothing method: "spline" (default) or "moving_average"}

\item{...}{additional parameters passed to \code{smooth.spline} or parameters
`n` and `save_bands_to_meta` for the moving average smoothing.}
}
\value{
a spectra object of with smoothed spectra
}
\description{
\code{smooth} runs each spectrum by a smoothing and returns the spectra
}
\examples{
library(spectrolab)

spec = as_spectra(spec_matrix_example, name_idx = 1)
spec = smooth(spec, parallel = FALSE)
}
\author{
Jose Eduardo Meireles
}
