% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_sensors.R
\name{match_sensors}
\alias{match_sensors}
\alias{match_sensors.spectra}
\title{Match spectra at sensor transitions}
\usage{
match_sensors(x, splice_at, fixed_sensor = 2, interpolate_wvl = c(5, 1))

\method{match_sensors}{spectra}(x, splice_at, fixed_sensor = 2, interpolate_wvl = c(5, 2))
}
\arguments{
\item{x}{spectra object}

\item{splice_at}{bands that serve as splice points, i.e the beginnings
of the rightmost sensor. Must be length 1 or 2 (max 3 sensors)}

\item{fixed_sensor}{sensor to keep fixed. Can be 1 or 2 if matching 2 sensors.
If matching 3 sensors, `fixed_sensor` must be 2 (default).}

\item{interpolate_wvl}{extent around splice_at values over which the splicing
factors will be calculated. Defaults to 5}
}
\value{
spectra object
}
\description{
\code{match_sensors} scales values of sensors 1 (VIS) and 3 (SWIR 2)
}
\details{
Splice_at has no default because sensor transition points vary between vendors
and individual instruments.
The function \code{guess_splice_at} can help you guess what those values could
be. However, \code{splice_at} is an important parameter though, so you should
visually inspect your spectra before assigning it.
Typical values in our own individual instruments were:
SVC ~ c(990, 1900),
ASD ~ c(1001, 1801).

If the factors used to match spectra are unreasonable, \code{match_sensors}
will throw. Unreasonable factors (f) are defined as 0.5 > f > 3 or NaN,
which happens when the value for the right sensor is 0.
}
\section{Methods (by class)}{
\itemize{
\item \code{spectra}: Match sensor overlap regions
}}

\author{
Jose Eduardo Meireles and Anna Schweiger
}
