% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_nodes.R
\name{order_nodes}
\alias{order_nodes}
\title{Group nodes by community}
\usage{
order_nodes(graph, membership, is_directed = "detect")
}
\arguments{
\item{graph}{The graph or adjacency matrix the membership vector was created
for.}

\item{membership}{A vector or matrix listing node communities. The output
from \code{\link[=cluster]{cluster()}} (should also work for other clustering
algorithms that return membership in the same format).}

\item{is_directed}{Whether the graph should be treated as directed or not.
By default, if the graph is symmetric it is treated as undirected.}
}
\value{
An index vector or matrix. The number of rows are equal to the value
of \code{subcluster} passed to \code{\link[=cluster]{cluster()}}.
}
\description{
Reorders the graph to group nodes in the same community together.
Useful for viewing community structure of a graph using a \code{heatmap()}.
}
\details{
Communities are ordered by size, so nodes in the largest community are
first. Within a community, nodes are order by highest-to-lowest degree.

If membership is in matrix form (the output from \code{\link[=cluster]{cluster()}}
with \code{subcluster} > 1) a matrix is returned with the indices for level one
in row 1 and level n in row n. Each row reorders the communities of the
previous row such that, at the second level, nodes are still grouped by
the first level communities. This allows the hierarchical structure to be
viewed.

See vignette for a multilevel example.
}
\examples{
if (require("igraph")) {
  n_nodes <- 100
  n_types <- 3
  # Mixing parameter (likelihood an edge is between communities).
  mu <- 0.3
  pref <- matrix(mu, n_types, n_types)
  diag(pref) <- 1 - mu
  g <- igraph::preference.game(n_nodes, types = n_types, pref.matrix = pref)
  # Use a dense matrix representation to easily apply index.
  adj <- as(g[], "matrix")
  memb <- speakeasyR::cluster(adj, seed = 222, max_threads = 2)
  ordering <- speakeasyR::order_nodes(adj, memb)
  \donttest{
  heatmap(adj[ordering, ordering], scale = "none", Rowv = NA, Colv = NA)
  }
}
}
