% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{SPCModellm}
\alias{SPCModellm}
\title{Data model based on a linear model}
\usage{
SPCModellm(formula, Delta = 0)
}
\arguments{
\item{formula}{the linear model specified as a formula.}

\item{Delta}{Object of class \code{"numeric"}.}
}
\description{
The parameters needed for running the chart are the fitted linear
model. Resampled data sets are created by resampling cases with
replacement (i.e. keeping observations together).
}
\examples{
n <- 1000
Xlinreg <- data.frame(x1= rbinom(n,1,0.4), x2= runif(n,0,1), x3= rnorm(n))
Xlinreg$y <- 2 + Xlinreg$x1 + Xlinreg$x2 + Xlinreg$x3 + rnorm(n)
\dontrun{
chartlinregCUSUM <- new("SPCCUSUM", model=SPCModellm(Delta=1,formula="y~x1+x2+x3"))
SPCproperty(data=Xlinreg,nrep=10,property="calARL",
            chart=chartlinregCUSUM,params=list(target=100))
#increase nrep in real applications.
#' chartlinregCUSUM2 <- new("SPCCUSUM",model=SPCModellm(Delta=1,formula="y~x1"))
SPCproperty(data=Xlinreg,nrep=10,property="calARL",
            chart=chartlinregCUSUM2,params=list(target=100))
#increase nrep in real applications.

chartlinregEWMA <- new("SPCEWMA", model=SPCModellm(Delta=0,formula="y~x1+x2+x3"),lambda=0.8)
SPCproperty(data=Xlinreg,nrep=10,property="calARL",
            chart=chartlinregEWMA,params=list(target=100))
#increase nrep in real applications.

chartlinregEWMA2 <- new("SPCEWMA",model=SPCModellm(Delta=0,formula="y~x1"),lambda=0.8)
SPCproperty(data=Xlinreg,nrep=10,property="calARL",
            chart=chartlinregEWMA2,params=list(target=100))
}
#increase nrep in real applications.
}

