% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{SPCModelNormal}
\alias{SPCModelNormal}
\title{Parametric Model for Normally Distributed Data with Centering and Scaling}
\usage{
SPCModelNormal(Delta = 0)
}
\arguments{
\item{Delta}{Half of this constant is subtracted for updates (before centering and scaling).}
}
\value{
An object of class \code{\link{SPCDataModel}}.
}
\description{
Returns a data model for univariate observations using normality
assumptions with updates that center and scale the observations and
potentially subtract half of a constant \code{Delta}. Subtracting
\eqn{Delta/2} is useful for CUSUM charts.
}
\details{
The parameters to the function have the following meaning.
\itemize{
\item data: a numeric vector.
\item xi: a list with two elements:
      \itemize{
      \item mu: the mean.
      \item sd: the standard deviation.
      }
\item P: a list with three elements:
      \itemize{
      \item mu: the mean.
      \item sd: the standard deviation.
      \item m: the number of data points to resample.
      }
}

The main operations are defined as follows:
\itemize{
\item updates(xi,data): returns the centered and scale version of the data from which \eqn{Delta/2} has been subtracted, i.e.
 \deqn{\frac{data-mu-Delta/2}{sd}}{(data-mu-Delta/2)/sd}.
\item resample(P): resamples \code{m} new data points from a normal distribution if mean \code{mu} and standard deviation \code{sd}.
}
}

