# 
# 
# This file contains a unit tests that make sure the complete workflow is working
# 

context('Test workflows') 

data(forestgap)
data(serengeti)

datasets <- list(forestgap[[3]], 
                 forestgap[2:4], 
                 serengeti[5:6])

test_that("The workflow functions work", { 
  skip_on_cran()
  
  for ( dataset in datasets ) { 
      
    # Generic indicators
    expect_true({
      capture.output({
        
        indics <- generic_sews(dataset) 
        
        print(indics)
        summary(indics)
        expect_true(is.data.frame(as.data.frame(indics)))
        
        indics.test <- indictest(indics, nperm = 9)
        print(indics.test)        
        summary(indics.test)      
        expect_true(is.data.frame(as.data.frame(indics.test)))
        
        if ( ! is.matrix(dataset) ) { # multiple values
          suppressWarnings( print( plot(indics.test) ) )
          suppressWarnings( print( plot(indics) ) )
        }
        
      })
    # Return true 
    TRUE})
    
    
    # Spectral-based indicators
    expect_true({
      capture.output({
        
        # These two comands should produce the same thing
        indics <- spectral_sews(dataset, 
                                 sdr_low_range  = c(0,  0.2), 
                                 sdr_high_range = c(.8, 1)) 
        
        indics <- spectral_sews(dataset, quiet = TRUE) 
        
        print(indics)
        summary(indics)
        expect_true(is.data.frame(as.data.frame(indics)))
        
        indics.test <- indictest(indics, nperm = 9)
        print(indics.test)        
        summary(indics.test)      
        as.data.frame(indics.test) 
        
        if ( ! is.matrix(dataset) ) { 
          suppressWarnings( print( plot(indics.test) ) )
          suppressWarnings( print( plot(indics) ) )
        }
        
        suppressWarnings( plot_spectrum(indics)      )
        suppressWarnings( plot_spectrum(indics.test) )
        
      })
        
    # Return true 
    TRUE})
    
    # PSD-based indicators
    skip_on_travis() # Sometimes vgam fails for some reason, so we skip 
                     # this test on travis for now. 
    expect_true({
      capture.output({
        
        indics <- suppressWarnings( patchdistr_sews(dataset, fit_lnorm = TRUE) )
        
        print(indics)
        summary(indics)
        expect_true(is.data.frame(as.data.frame(indics)))
        
        if ( ! is.matrix(dataset) ) { 
          suppressWarnings( print( plot(indics) ) )
        }
        
        # This test can sometimes fail (?! something to investigate ?)
        predict(indics)
        
        suppressWarnings( plot_distr(indics) )
        
      })
    # Return true 
    TRUE})
    
  }
  
})

