% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{patchsizes}
\alias{patchsizes}
\title{Get patch sizes.}
\usage{
patchsizes(mat, merge = FALSE, nbmask = matrix(c(0, 1, 0, 1, 0, 1, 0, 1, 0),
  ncol = 3), wrap = FALSE)
}
\arguments{
\item{mat}{A logical matrix or a list of these matrices.}

\item{merge}{Controls whether the obtained patch size distributions are to 
be pooled together if mat is a list of matrices.}

\item{nbmask}{a "neighboring mask": a matrix with odd dimensions describing
which neighbors are to be considered as neighbors around a cell 
(see examples).}

\item{wrap}{Whether to wrap around lattice boundaries (`TRUE`/`FALSE`), 
effectively using periodic boundaries.}
}
\value{
If mat is a logical matrix, then the function returns a vector of 
  patch sizes. If mat is a list of logical matrices, then it returns 
  a list of vectors of patch sizes: this list is flattened if merge is TRUE.
}
\description{
Get the distribution of patch sizes of a logical matrix
}
\examples{
data(forestgap)
patchsizes(forestgap[[5]])

}
\seealso{
\code{\link{label}}
}
