% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_grid_search.R, R/highest_concentration.R
\name{highest_concentration}
\alias{highest_concentration}
\title{Highest concentration risk}
\usage{
highest_concentration(
  df,
  value,
  lon = lon,
  lat = lat,
  lowerbound = NULL,
  radius = 200,
  grid_distance = 25,
  gh_precision = 6,
  display_progress = TRUE
)

highest_concentration(
  df,
  value,
  lon = lon,
  lat = lat,
  lowerbound = NULL,
  radius = 200,
  grid_distance = 25,
  gh_precision = 6,
  display_progress = TRUE
)
}
\arguments{
\item{df}{data.frame of locations, should at least include column for longitude, latitude and sum insured}

\item{value}{column name with value of interest to summarize (e.g. sum insured)}

\item{lon}{column name with longitude (defaults to `lon`)}

\item{lat}{column name with latitude (defaults to `lat`)}

\item{lowerbound}{set lower bound for outcome (defaults to NULL)}

\item{radius}{radius (in meters) (default is 200m)}

\item{grid_distance}{distance (in meters) for precision of concentration risk (default is 25m).
`neighborhood_search()` can be used to search for coordinates with even higher concentrations
in the neighborhood of the highest concentrations.}

\item{gh_precision}{positive integer to define geohash precision. See details.}

\item{display_progress}{show progress bar (TRUE/FALSE). Defaults to TRUE.}
}
\value{
data.frame with coordinates (lon/lat) with the highest concentrations

data.frame with coordinates (lon/lat) with the highest concentrations
}
\description{
Find the centre coordinates of a circle with a fixed radius that maximizes the coverage of total fire risk insured. `highest_concentration()`
returns the coordinates (lon/lat) and the corresponding concentration. The concentration is defined as the sum of all observations
within a circle of a certain radius. See \code{\link{concentration}} for determining concentration for pre-defined coordinates.

Find the centre coordinates of a circle with a fixed radius that maximizes the coverage of total fire risk insured. `highest_concentration()`
returns the coordinates (lon/lat) and the corresponding concentration. The concentration is defined as the sum of all observations
within a circle of a certain radius. See \code{\link{concentration}} for determining concentration for pre-defined coordinates.
}
\details{
A recently European Commission regulation requires insurance
companies to determine the maximum value of insured fire risk policies of
all buildings that are partly or fully located within circle of a radius of 200m
(Commission Delegated Regulation (EU), 2015, Article 132). The problem can
be stated as: "find the centre coordinates of a circle with a fixed radius
that maximizes the coverage of total fire risk insured". This can be viewed
as a particular instance of the Maximal Covering Location Problem (MCLP)
with fixed radius. See Gomes (2018) for a solution to the maximum fire
risk insured capital problem using a multi-start local search meta-heuristic.
The computational performance of \code{highest_concentration()} is
investigated to overcome the long times the MCLP algorithm is taking.
\code{highest_concentration()} is written in C++, and for 500,000 buildings
it needs about 5-10 seconds to determine the maximum value of insured fire risk
policies that are partly or fully located within circle of a radius of 200m.

`highest_concentration()` uses Gustavo Niemeyer's wonderful and elegant
geohash coordinate system. Niemeyer's Geohash method encodes latitude and
longitude as binary string where each binary value derived from a decision
as to where the point lies in a bisected region of latitude or longitudinal
space. The first step is to convert all latitude/longitude coordinates into
geohash-encoded strings.

The length of the geohash (`gh_precision`) controls the 'zoom level':
\itemize{
\item precision 5 is 4.89 x 4.89km;
\item precision 6 is 1.22km x 0.61km;
\item precision 7 is 153m x 153m;
\item precision 8 is 39m x 19m.
}

For a circle with a radius of 200m the precision of the geohash should
be set equal to 6 (default). Then the `value` column is aggregated (sum)
per geohash (with a buffer of size `radius` around each geohash,
since the coordinates of the highest concentration can be near the edge of
the geohash). The geohashes with a aggregated value below the lowerbound
are removed, where the lowerbound is equal to the maximum of the
`value` column. Then a grid is created, with a distance of `grid_distance`
between the points. See example section for a illustration of the algorithm.
As a last step for each grid point the concentration is calculated.

A recently European Commission regulation requires insurance
companies to determine the maximum value of insured fire risk policies of
all buildings that are partly or fully located within circle of a radius of 200m
(Commission Delegated Regulation (EU), 2015, Article 132). The problem can
be stated as: "find the centre coordinates of a circle with a fixed radius
that maximizes the coverage of total fire risk insured". This can be viewed
as a particular instance of the Maximal Covering Location Problem (MCLP)
with fixed radius. See Gomes (2018) for a solution to the maximum fire
risk insured capital problem using a multi-start local search meta-heuristic.
The computational performance of \code{highest_concentration()} is
investigated to overcome the long times the MCLP algorithm is taking.
\code{highest_concentration()} is written in C++, and for 500,000 buildings
it needs about 5-10 seconds to determine the maximum value of insured fire risk
policies that are partly or fully located within circle of a radius of 200m.

`highest_concentration()` uses Gustavo Niemeyer's wonderful and elegant
geohash coordinate system. Niemeyer's Geohash method encodes latitude and
longitude as binary string where each binary value derived from a decision
as to where the point lies in a bisected region of latitude or longitudinal
space. The first step is to convert all latitude/longitude coordinates into
geohash-encoded strings.

The length of the geohash (`gh_precision`) controls the 'zoom level':
\itemize{
\item precision 5 is 4.89 x 4.89km;
\item precision 6 is 1.22km x 0.61km;
\item precision 7 is 153m x 153m;
\item precision 8 is 39m x 19m.
}

For a circle with a radius of 200m the precision of the geohash should
be set equal to 6 (default). Then the `value` column is aggregated (sum)
per geohash (with a buffer of size `radius` around each geohash,
since the coordinates of the highest concentration can be near the edge of
the geohash). The geohashes with a aggregated value below the lowerbound
are removed, where the lowerbound is equal to the maximum of the
`value` column. Then a grid is created, with a distance of `grid_distance`
between the points. See example section for a illustration of the algorithm.
As a last step for each grid point the concentration is calculated.
}
\examples{
 \dontrun{
# Find highest concentration with a precision of a grid of 25 meters
hc1 <- highest_concentration(Groningen, amount, radius = 200, grid_distance = 25)

# Look for coordinates with even higher concentrations in the
# neighborhood of the coordinates with the highest concentration
hc1_nghb <- neighborhood_gh_search(hc1, max.call = 7000)
print(hc1_nghb)

# Create map with geohashes above the lowerbound
# The highest concentration lies in one of the geohashes
plot(hc1)

# Create map with highest concentration
plot(hc1_nghb)
}

 \dontrun{
# Find highest concentration with a precision of a grid of 25 meters
hc1 <- highest_concentration(Groningen, amount, radius = 200, grid_distance = 25)

# Look for coordinates with even higher concentrations in the
# neighborhood of the coordinates with the highest concentration
hc1_nghb <- neighborhood_gh_search(hc1, max.call = 7000)
print(hc1_nghb)

# Create map with geohashes above the lowerbound
# The highest concentration lies in one of the geohashes
plot(hc1)

# Create map with highest concentration
plot(hc1_nghb)
}

}
\references{
Commission Delegated Regulation (EU) (2015). Solvency II Delegated Act 2015/35. Official Journal of the European Union, 58:124.

Gomes M.I., Afonso L.B., Chibeles-Martins N., Fradinho J.M. (2018). Multi-start Local Search Procedure for the Maximum Fire Risk Insured Capital Problem. In: Lee J., Rinaldi G., Mahjoub A. (eds) Combinatorial Optimization. ISCO 2018. Lecture Notes in Computer Science, vol 10856. Springer, Cham. <doi:10.1007/978-3-319-96151-4_19>

Commission Delegated Regulation (EU) (2015). Solvency II Delegated Act 2015/35. Official Journal of the European Union, 58:124.

Gomes M.I., Afonso L.B., Chibeles-Martins N., Fradinho J.M. (2018). Multi-start Local Search Procedure for the Maximum Fire Risk Insured Capital Problem. In: Lee J., Rinaldi G., Mahjoub A. (eds) Combinatorial Optimization. ISCO 2018. Lecture Notes in Computer Science, vol 10856. Springer, Cham. <doi:10.1007/978-3-319-96151-4_19>
}
\author{
Martin Haringa

Martin Haringa
}
