% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_performance.R
\name{get_performance}
\alias{get_performance}
\title{Gets out-of-bag performance scores from a model}
\usage{
get_performance(model)
}
\arguments{
\item{model}{Model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
A data frame with four columns:
\itemize{
\item \code{metric} Name of the performance metric.
\item \code{median} Value of the performance metric. Truly a median only if the model is fitted with \code{\link[=rf_repeat]{rf_repeat()}}.
\item \code{median_absolute_deviation} median absolute deviation (MAD), only if the model is fitted with \code{\link[=rf_repeat]{rf_repeat()}}, and \code{NA} otherwise.
}
}
\description{
Returns the performance slot of an \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}} model computed on the out-of-bag data.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)
 data(distance.matrix)

 #fitting random forest model
 rf.model <- rf(
   data = plant_richness_df,
   dependent.variable.name = "richness_species_vascular",
   predictor.variable.names = colnames(plant_richness_df)[5:21],
   distance.matrix = distance_matrix,
   distance.thresholds = 0,
   n.cores = 1,
   verbose = FALSE
 )

 #getting model performance
 x <- get_performance(rf.model)
 x

}
}
\seealso{
\code{\link[=print_performance]{print_performance()}}
}
