% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar.R
\name{sar}
\alias{sar}
\title{Surface Area Ratio}
\usage{
sar(x, s = NULL, scale = TRUE)
}
\arguments{
\item{x}{A terra SpatRaster object}

\item{s}{cell resolution (default is NULL and not needed if projection 
is in planar units)}

\item{scale}{(TRUE/FALSE) Scale (row standardize) results}
}
\value{
A terra SpatRaster class object of the Surface Area Ratio
}
\description{
Calculates the Berry (2002) Surface Area Ratio based on slope
}
\note{
SAR is calculated as: resolution^2 * cos( (degrees(slope) * (pi / 180)) )
}
\examples{
 library(terra)
 elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
 ( surface.ratio <- sar(elev) )
   plot(surface.ratio)
    
}
\references{
Berry, J.K. (2002). Use surface area for realistic calculations. Geoworld 15(9):20-1.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
