% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explode.R
\name{explode}
\alias{explode}
\title{Explodes multipart features}
\usage{
explode(...)
}
\arguments{
\item{...}{Parameters to be passed to st_cast}
}
\description{
Explodes multipart features into single part
}
\note{
Multipart geometries are a data structure where a single attribute 
shares multiple features (polygons, points, lines). This function 
dissaggregates the data into a one-to-one match.
}
\examples{
\donttest{
library(sf)
  nc <- st_read(system.file("shape/nc.shp", package="sf"))
  nc <- suppressWarnings(st_cast(nc, "POLYGON"))
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
