% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.distance.R
\name{subsample.distance}
\alias{subsample.distance}
\title{Distance-based subsampling}
\usage{
subsample.distance(
  x,
  size,
  d,
  d.max = NULL,
  replacement = FALSE,
  latlong = FALSE,
  echo = FALSE
)
}
\arguments{
\item{x}{A spatial polygons or points sp object}

\item{size}{Subsample size}

\item{d}{Minimum sampling distance}

\item{d.max}{Maximum sampling distance}

\item{replacement}{(FALSE/TRUE) Subsample with replacement}

\item{latlong}{(FALSE/TRUE) Is the data in a geographic projection}

\item{echo}{(FALSE/TRUE) Print min and max sample distances}
}
\value{
A subsampled spatial polygons or points sp object
}
\description{
Draws a minimum, and optional maximum constrained, distance sub-sampling
}
\note{
This function provides a distance constrained subsample of existing point 
      or polygon data
}
\examples{
     
\donttest{
library(sp)
data(meuse)
  coordinates(meuse) <- ~ x+y

# Subsample with a 500m minimum sample spread 
sub.meuse <- subsample.distance(meuse, size = 10, d = 500, echo = TRUE)  
  plot(meuse, pch=19, main="min dist = 500")
    points(sub.meuse, pch=19, col="red") 

# Check distances	
dm <- spDists(sub.meuse)
  diag(dm) <- NA
cat("\n", "Min distance for subsample", min(dm, na.rm=TRUE), "\n")  
cat("Max distance for subsample", max(dm, na.rm=TRUE), "\n") 

  # Subsample with a 500m minimum and 3500m maximum sample spread   
  sub.meuse <- subsample.distance(meuse, size = 10, d = 500, d.max = 3500)  
    plot(meuse,pch=19, main="min dist = 500, max dist = 3500")
      points(sub.meuse, pch=19, col="red") 

  # Check distances		
  dm <- spDists(sub.meuse)
    diag(dm) <- NA
  cat("Min distance for subsample", min(dm, na.rm=TRUE), "\n")  
  cat("Max distance for subsample", max(dm, na.rm=TRUE), "\n")    
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
