% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimized.sample.variance.R
\name{optimized.sample.variance}
\alias{optimized.sample.variance}
\title{Optimized sample variance}
\usage{
optimized.sample.variance(x, n, type = "maximized")
}
\arguments{
\item{x}{A vector to draw a sample from}

\item{n}{Number of samples to draw}

\item{type}{Type of sample variance optimization c("maximized", "minimized")}
}
\value{
A data.frame with "idx" representing the index of the original vector and "y" 
          is the value of the sampled data
}
\description{
Draws an optimal sample that minimizes or maximizes the sample variance
}
\examples{
 library(sp)
   data(meuse)
   coordinates(meuse) <- ~x+y

 n = 15
 # Draw n samples that maximize the variance of y
 ( max.sv <- optimized.sample.variance(meuse$zinc, 15) )
 
 # Draw n samples that minimize the variance of y
 ( min.sv <- optimized.sample.variance(meuse$zinc, 15, type="minimized") )
 
 # Plot results
 plot(meuse, pch=19, col="grey")
   plot(meuse[max.sv$idx,], col="red", add=TRUE, pch=19)
     plot(meuse[min.sv$idx,], col="blue", add=TRUE, pch=19)
 	  box()
     legend("topleft", legend=c("population","maximized variance", 
            "minimized variance"), col=c("grey","red","blue"),  
            pch=c(19,19,19))

\dontrun{
 # Raster example (not memory safe) 
 library(raster)
   r <- raster(system.file("external/test.grd", package="raster"))
  
# Calculate optimal sample variance and coerce to SpatialPointDataFrame using xyFromCell
     ( min.sv <- optimized.sample.variance(getValues(r), n, type="minimized") )
      min.sv <- sp::SpatialPointsDataFrame(xyFromCell(r, min.sv[,"idx"], 
                                           spatial=TRUE), data=min.sv) 
     ( max.sv <- optimized.sample.variance(getValues(r), n) )
      max.sv <- sp::SpatialPointsDataFrame(xyFromCell(r, max.sv[,"idx"], 
                                           spatial=TRUE), data=max.sv)

 plot(r)
   plot(max.sv, col="blue", add=TRUE, pch=19)
   plot(min.sv, col="red", add=TRUE, pch=19)
   box()
 legend("topleft", legend=c("maximized variance", "minimized variance"),
        col=c("red","blue"), pch=c(19,19))
 }  
 
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
