% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess.ci.R
\name{loess.ci}
\alias{loess.ci}
\title{Loess with confidence intervals}
\usage{
loess.ci(y, x, p = 0.95, plot = FALSE, ...)
}
\arguments{
\item{y}{Dependent variable, vector}

\item{x}{Independent variable, vector}

\item{p}{Percent confidence intervals (default is 0.95)}

\item{plot}{Plot the fit and confidence intervals}

\item{...}{Arguments passed to loess}
}
\value{
A list object with:

loess Predicted values

se Estimated standard error for each predicted value

lci Lower confidence interval

uci Upper confidence interval

df Estimated degrees of freedom

rs Residual scale of residuals used in computing the standard errors
}
\description{
Calculates a local polynomial regression fit with associated confidence intervals
}
\examples{
 x <- seq(-20, 20, 0.1)
 y <- sin(x)/x + rnorm(length(x), sd=0.03)
 p <- which(y == "NaN")
   y <- y[-p]	
   x <- x[-p]
 
 par(mfrow=c(2,2))  
 lci <- loess.ci(y, x, plot=TRUE, span=0.10)
 lci <- loess.ci(y, x, plot=TRUE, span=0.30)
 lci <- loess.ci(y, x, plot=TRUE, span=0.50)
 lci <- loess.ci(y, x, plot=TRUE, span=0.80)

}
\references{
W. S. Cleveland, E. Grosse and W. M. Shyu (1992) Local regression models. Chapter 8 of Statistical Models in S eds J.M. Chambers and T.J. Hastie, Wadsworth & Brooks/Cole.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
