% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcap.R
\name{mcap}
\alias{mcap}
\title{Monte Carlo adjusted profile}
\usage{
mcap(lp, parameter, confidence = 0.95, lambda = 1, Ngrid = 1000)
}
\arguments{
\item{lp}{a vector of profile likelihood evaluations.}

\item{parameter}{the corresponding values of the focal parameter.}

\item{confidence}{the required level of the confidence interval.}

\item{lambda}{the loess parameter used to smooth the profile.}

\item{Ngrid}{the number of points to evaluate the smoothed profile.}
}
\value{
\code{mcap()} returns a list including the smoothed profile,
a quadratic approximation, and the constructed confidence interval.
}
\description{
Given a collection of points maximizing the likelihood over a range
of fixed values of a focal parameter, this function constructs
a profile likelihood confidence interval accommodating both
Monte Carlo error in the profile and statistical uncertainty present
in the likelihood function.
}
\author{
Edward L. Ionides
}
