% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpfilter.R
\docType{class}
\name{bpfilter}
\alias{bpfilter}
\alias{bpfilter-spatPomp}
\alias{bpfilter,spatPomp-method}
\title{Block particle filter (BPF)}
\usage{
\S4method{bpfilter}{spatPomp}(
  object,
  Np,
  block_size,
  block_list,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{object}{A \code{spatPomp} object.}

\item{Np}{The number of particles used within each replicate for the adapted simulations.}

\item{block_size}{The number of spatial units per block. If this is provided, the method subdivides units approximately evenly
into blocks with size \code{block_size}.}

\item{block_list}{List that specifies an exact partition of the spatial units. Each partition element, or block, is
an integer vector of neighboring units.}

\item{...}{If a \code{params} argument is specified, \code{abf} will estimate the likelihood at that parameter set instead of at \code{coef(object)}.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
Upon successful completion, \code{bpfilter()} returns an object of class
\sQuote{bpfilterd_spatPomp} containing the algorithmic parameters used to run \code{bpfilter()}
and the estimated likelihood.
}
\description{
An implementation of the block particle filter algorithm of Rebeschini and van Handel (2015), which is used to estimate the filter distribution
of a spatiotemporal partially-observed Markov process.
\code{bpfilter} requires a partition of the spatial units which can be provided by either the \code{block_size} or the \code{block_list} argument.
The elements of the partition are called blocks. We perform resampling for each block independently based on sample weights within the block.
Each resampled block only contains latent states for the spatial components within the block which allows for a ``cross-pollination" of
particles where the highest weighted segments of each particle are more likely to be resampled and get combined with resampled components of
other particles. The method mitigates the curse of dimensionality by resampling locally.
}
\section{Details}{

Only one of \code{block_size} or \code{block_list} should be specified.
If both or neither is provided, an error is triggered.
}

\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{logLik}}}{ yields an estimate of the log-likelihood of the data under the model. }
}
}

\examples{
# Create a simulation of a Brownian motion
b <- bm(U=6, N=10)

# Run BPF with the specified number of units per block
bpfilterd_b1 <- bpfilter(b, Np = 100, block_size = 2)

# Run BPF with the specified partition
bpfilterd_b2 <- bpfilter(b,
                         Np = 20,
                         block_list = list(c(1,2), c(3,4), c(5,6)))

# Get a likelihood estimate
logLik(bpfilterd_b2)

}
\references{
\rebeschini2015
}
\seealso{
Other particle filter methods: 
\code{\link{abfir}()},
\code{\link{abf}()},
\code{\link{enkf}()},
\code{\link{girf}()},
\code{\link{ienkf}()},
\code{\link{igirf}()},
\code{\link{iubf}()}
}
\concept{particle filter methods}
