% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{coerce_to_sparse_tibble}
\alias{coerce_to_sparse_tibble}
\title{Coerce sparse matrix to tibble with sparse columns}
\usage{
coerce_to_sparse_tibble(x)
}
\arguments{
\item{x}{sparse matrix.}
}
\value{
tibble with sparse columns
}
\description{
Turning a sparse matrix into a tibble.
}
\details{
The only requirement from the sparse matrix is that it contains column names.
}
\examples{
\dontshow{if (rlang::is_installed("tibble")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set.seed(1234)
mat <- matrix(sample(0:1, 100, TRUE, c(0.9, 0.1)), nrow = 10)
colnames(mat) <- letters[1:10]
sparse_mat <- Matrix::Matrix(mat, sparse = TRUE)
sparse_mat

res <- coerce_to_sparse_tibble(sparse_mat)
res

# All columns are sparse
vapply(res, is_sparse_vector, logical(1))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=coerce_to_sparse_data_frame]{coerce_to_sparse_data_frame()}} \code{\link[=coerce_to_sparse_matrix]{coerce_to_sparse_matrix()}}
}
