% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{cholPermute}
\alias{cholPermute}
\title{Sparse Cholesky factorisation with fill-in reducing permutations}
\usage{
cholPermute(Q)
}
\arguments{
\item{Q}{precision matrix of class \code{matrix}, \code{Matrix} (column-compressed, i.e., \code{dgCMatrix} or \code{dsCMatrix}), or \code{spam}}
}
\value{
A list with two elements, Qpermchol (the permuted Cholesky factor) and P (the permutation matrix) of class Matrix. Note that \code{spam} matrices are not returned to comply with the Takahashi_Davis function which requires objects of class \code{Matrix}.
}
\description{
This function is similar to chol(A, pivot=T) when A is a sparse matrix. The fill-in reduction permutation is the approximate minimum degree permutation of
Davis' SuiteSparse package configured to be slightly more aggressive than that in the Matrix package.
}
\examples{
require(Matrix)
cholPermute(sparseMatrix(i = c(1,1,2,2),
                         j = c(1, 2, 1, 2),
                         x = c(0.1, 0.2, 0.2, 1)))
}
\references{
Havard Rue and Leonhard Held (2005). Gaussian Markov Random Fields: Theory and Applications. Chapman & Hall/CRC Press
}
\keyword{Cholesky}
\keyword{factor}
