% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgl_irwls.R
\name{make_irls_warmup}
\alias{make_irls_warmup}
\title{Create starting values for iterative reweighted least squares}
\usage{
make_irls_warmup(nobs, nvars, b0 = 0, beta = double(nvars), r = double(nobs))
}
\arguments{
\item{nobs}{Number of observations in the response (or rows in \code{x}).}

\item{nvars}{Number of columns in \code{x}}

\item{b0}{Scalar. Initial value for the intercept.}

\item{beta}{Vector. Initial values for the coefficients. Must be length
\code{nvars} (or a scalar).}

\item{r}{Vector. Initial values for the deviance residuals. Must be length
\code{nobs} (or a scalar).}
}
\value{
List of class \code{irlsspgl_warmup}
}
\description{
This function may be used to create potentially valid starting
values for calling \code{\link[=sparsegl]{sparsegl()}} with a \code{\link[stats:family]{stats::family()}} object.
It is not typically necessary to call this function (as it is used
internally to create some), but in some cases, especially with custom
generalized linear models, it may improve performance.
}
\details{
Occasionally, the irls fitting routine may fail with an admonition to
create valid starting values.
}
