% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-generics.R, R/sparsebnUtils-inference.R
\name{estimate.covariance}
\alias{estimate.covariance}
\alias{estimate.precision}
\alias{get.covariance}
\alias{get.precision}
\title{Estimating undirected graphs}
\usage{
estimate.covariance(fit, data)

estimate.precision(fit, data)

get.covariance(coefs, vars)

get.precision(coefs, vars)
}
\arguments{
\item{fit}{fitted \code{\link{sparsebnFit}} or \code{\link{sparsebnPath}} object.}

\item{data}{data as \code{\link{sparsebnData}} object.}

\item{coefs}{coefficients of DAG.}

\item{vars}{conditional variances of DAG.}

\item{...}{(optional) additional parameters}
}
\value{
Covariance or precision (inverse covariance) matrix as \code{\link[Matrix]{Matrix}}.
}
\description{
Methods for inferring (i) Covariance matrices and (ii) Precision matrices,
the latter of which correspond to an undirected graphical model for the underlying
distribution.
}
\details{
See Sections 2.1 and 2.2 (equation (6)) of Aragam and Zhou (2015) for more details.
}

