/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparklyr.DFCollectionUtils$;
import sparklyr.Logger;
import sparklyr.PartitionUtils$;
import sparklyr.RUtils$;

public final class RDSCollector$ {
    public static final RDSCollector$ MODULE$ = new RDSCollector$();

    /*
     * WARNING - void declaration
     */
    public void collect(Dataset<Row> df, Seq<String> outputFiles) {
        BoxedUnit boxedUnit;
        RDD rDD = df.rdd();
        if (rDD == null) {
            throw null;
        }
        RDD getNumPartitions_this = rDD;
        Object var22_3 = null;
        int numPartitions = getNumPartitions_this.partitions().length;
        if (outputFiles.length() != numPartitions) {
            throw new IllegalArgumentException(new StringBuilder(87).append("Number of output file(s) does not match input dataframe's number of partitions (").append(outputFiles.length()).append(" vs. ").append(numPartitions).append(").").toString());
        }
        Tuple2<Dataset<Row>, Tuple2<String, String>[]> tuple2 = DFCollectionUtils$.MODULE$.prepareDataFrameForCollection(df);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Object object = tuple2._2();
        Dataset transformedDf = (Dataset)tuple2._1();
        Tuple2[] dtypes = (Tuple2[])object;
        transformedDf.cache();
        int[] partitionSizes = new int[numPartitions];
        for (int[] nArray : PartitionUtils$.MODULE$.computePartitionSizes((Dataset<Row>)transformedDf)) {
            RDSCollector$.$anonfun$collect$1(partitionSizes, nArray);
        }
        Object var14_10 = null;
        this.writeHeaders(transformedDf.sqlContext().sparkContext(), outputFiles, (Seq<Tuple2<String, String>>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)dtypes));
        String[] cols = transformedDf.columns();
        Configuration hadoopConf = transformedDf.sqlContext().sparkContext().hadoopConfiguration();
        SerializableWritable serializedHadoopConf = new SerializableWritable((Writable)hadoopConf);
        int n = 0;
        int until$extension_end = cols.length;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            int n2 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
            RDSCollector$.$anonfun$collect$2(transformedDf, cols, serializedHadoopConf, outputFiles, partitionSizes, dtypes, n2);
            boxedUnit = BoxedUnit.UNIT;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            boxedUnit = null;
        }
        IndexedSeq cfr_ignored_0 = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var17_19 = null;
        Object var18_20 = null;
        Object var19_21 = null;
        boxedUnit = null;
        Logger logger = new Logger("RDSCollector", 0);
        FileSystem fs = FileSystem.get((Configuration)hadoopConf);
        outputFiles.foreach((Function1 & Serializable)o -> {
            RDSCollector$.$anonfun$collect$4(cols, fs, logger, o);
            return BoxedUnit.UNIT;
        });
    }

    private void writeHeaders(SparkContext sc, Seq<String> outputFiles, Seq<Tuple2<String, String>> dtypes) {
        FileSystem fs = FileSystem.get((Configuration)sc.hadoopConfiguration());
        ((IterableOnceOps)outputFiles.map((Function1 & Serializable)p -> fs.create(new Path(new StringBuilder(4).append((String)p).append(".hdr").toString())))).foreach((Function1 & Serializable)fos -> {
            RDSCollector$.$anonfun$writeHeaders$2(dtypes, fos);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$collect$1(int[] partitionSizes$1, int[] p) {
        int partitionSize;
        int partitionId = p[0];
        partitionSizes$1[partitionId] = partitionSize = p[1];
    }

    public static final /* synthetic */ void $anonfun$collect$3(SerializableWritable serializedHadoopConf$1, Seq outputFiles$1, int idx$1, int[] partitionSizes$1, Tuple2[] dtypes$1, Iterator iter) {
        FSDataOutputStream fos = FileSystem.get((Configuration)((Configuration)serializedHadoopConf$1.value())).create(new Path(new StringBuilder(5).append((String)outputFiles$1.apply(TaskContext$.MODULE$.getPartitionId())).append(".col_").append(idx$1).toString()));
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            RUtils$.MODULE$.writeColumn(dos, partitionSizes$1[TaskContext$.MODULE$.getPartitionId()], (Iterator<Row>)iter, (String)dtypes$1[idx$1]._2());
        }
        finally {
            dos.close();
            bos.close();
            fos.close();
        }
    }

    public static final /* synthetic */ void $anonfun$collect$2(Dataset transformedDf$1, String[] cols$1, SerializableWritable serializedHadoopConf$1, Seq outputFiles$1, int[] partitionSizes$1, Tuple2[] dtypes$1, int idx) {
        Dataset colDf = transformedDf$1.select(cols$1[idx], (Seq)Nil$.MODULE$);
        colDf.cache();
        colDf.foreachPartition((Function1 & Serializable)iter -> {
            RDSCollector$.$anonfun$collect$3(serializedHadoopConf$1, outputFiles$1, idx, partitionSizes$1, dtypes$1, iter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$collect$5(String o$1, int idx) {
        return new StringBuilder(5).append(o$1).append(".col_").append(idx).toString();
    }

    public static final /* synthetic */ Path $anonfun$collect$6(String x) {
        return new Path(x);
    }

    public static final /* synthetic */ java.nio.file.Path $anonfun$collect$7(String x) {
        return java.nio.file.Path.of(new URI(x).getPath(), new String[0]);
    }

    public static final /* synthetic */ int $anonfun$collect$8(SeekableByteChannel ch$1, java.nio.file.Path path) {
        int n;
        try (FileChannel pch = FileChannel.open(path, StandardOpenOption.READ);){
            MappedByteBuffer buf = pch.map(FileChannel.MapMode.READ_ONLY, 0L, pch.size());
            n = ch$1.write(buf);
        }
        return n;
    }

    public static final /* synthetic */ Object $anonfun$collect$9(FileSystem fs$1, Logger logger$1, Path path) {
        Boolean bl;
        try {
            bl = fs$1.delete(path, false);
        }
        catch (Throwable e) {
            logger$1.logWarning(new StringBuilder(34).append("Failed to delete temporary file ").append(path).append(": ").append(e.toString()).toString());
            bl = BoxedUnit.UNIT;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$collect$4(String[] cols$1, FileSystem fs$1, Logger logger$1, String o) {
        String string;
        String[] stringArray = new String[]{new StringBuilder(4).append(o).append(".hdr").toString()};
        int n = 0;
        int until$extension_end = cols$1.length;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            string = RDSCollector$.$anonfun$collect$5(o, BoxesRunTime.unboxToInt((Object)object));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        Object var11_6 = null;
        Object var12_7 = null;
        Object var13_8 = null;
        string = null;
        String[] inputs = (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)stringArray, (IterableOnce)((IndexedSeq)map_strictOptimizedMap_b.result()), ClassTag$.MODULE$.apply(String.class));
        int map$extension_len = inputs.length;
        Path[] map$extension_ys = new Path[map$extension_len];
        if (map$extension_len > 0) {
            for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                Path array_update_value;
                String string2 = inputs[map$extension_i];
                map$extension_ys[map$extension_i] = array_update_value = new Path(string2);
                Object var30_16 = null;
            }
        }
        Object var16_13 = null;
        Path[] paths = map$extension_ys;
        if (fs$1 instanceof LocalFileSystem) {
            int map$extension_len2 = inputs.length;
            java.nio.file.Path[] map$extension_ys2 = new java.nio.file.Path[map$extension_len2];
            if (map$extension_len2 > 0) {
                for (int map$extension_i = 0; map$extension_i < map$extension_len2; ++map$extension_i) {
                    java.nio.file.Path array_update_value;
                    map$extension_ys2[map$extension_i] = array_update_value = RDSCollector$.$anonfun$collect$7(inputs[map$extension_i]);
                    Object var31_21 = null;
                }
            }
            Object var19_19 = null;
            java.nio.file.Path[] localPaths = map$extension_ys2;
            try (SeekableByteChannel ch = Files.newByteChannel(Paths.get(new URI(o).getPath(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                for (java.nio.file.Path path : localPaths) {
                    RDSCollector$.$anonfun$collect$8(ch, path);
                }
            }
        } else {
            Path dst = new Path(o);
            fs$1.createNewFile(dst);
            fs$1.concat(dst, paths);
        }
        for (Path path : paths) {
            RDSCollector$.$anonfun$collect$9(fs$1, logger$1, path);
        }
    }

    public static final /* synthetic */ void $anonfun$writeHeaders$2(Seq dtypes$2, FSDataOutputStream fos) {
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            RUtils$.MODULE$.writeXdrHeader(dos);
            RUtils$.MODULE$.writeDataFrameHeader(dos, (Seq<Tuple2<String, String>>)dtypes$2);
        }
        finally {
            dos.close();
            bos.close();
            fos.close();
        }
    }

    private RDSCollector$() {
    }

    public static final /* synthetic */ Object $anonfun$collect$1$adapted(int[] partitionSizes$1, int[] p) {
        RDSCollector$.$anonfun$collect$1(partitionSizes$1, p);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$collect$5$adapted(String o$1, Object idx) {
        return RDSCollector$.$anonfun$collect$5(o$1, BoxesRunTime.unboxToInt((Object)idx));
    }

    public static final /* synthetic */ Object $anonfun$collect$8$adapted(SeekableByteChannel ch$1, java.nio.file.Path path) {
        return BoxesRunTime.boxToInteger((int)RDSCollector$.$anonfun$collect$8(ch$1, path));
    }
}

