/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.immutable.ParSeq$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import sparklyr.Collectors;
import sparklyr.Collectors$;
import sparklyr.DFCollectionUtils$;
import sparklyr.RUtils$;
import sparklyr.RawSXP;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Object collect(Dataset<Row> df, String separator, String impl) {
        Object object;
        Tuple2<Dataset<Row>, Tuple2<String, String>[]> tuple2 = DFCollectionUtils$.MODULE$.prepareDataFrameForCollection(df);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset transformed_df = (Dataset)tuple2._1();
        Tuple2[] dtypes = (Tuple2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transformed_df, (Object)dtypes);
        Tuple2 tuple23 = tuple22;
        Dataset transformed_df2 = (Dataset)tuple23._1();
        Tuple2[] dtypes2 = (Tuple2[])tuple23._2();
        Function1 & Serializable & scala.Serializable collectRowsFromIterator = (Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.collectRows((Iterator<Row>)x$2, dtypes2, separator, (int)df.count());
        String string = impl;
        if ("row-wise".equals(string)) {
            object = collectRowsFromIterator.apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformed_df2.collect())).iterator());
        } else if ("row-wise-iter".equals(string)) {
            RDD rdd = transformed_df2.rdd().cache();
            object = collectRowsFromIterator.apply((Object)rdd.toLocalIterator());
        } else if ("column-wise".equals(string)) {
            object = this.collectColumns((Row[])df.collect(), dtypes2, separator);
        } else {
            throw new MatchError((Object)string);
        }
        return object;
    }

    private Object collectRows(Iterator<Row> iter, Tuple2<String, String>[] dtypes, String separator, int maxNumRows) {
        Collectors.ColumnCtx[] columns = (Collectors.ColumnCtx[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dtypes)).map((Function1 & Serializable & scala.Serializable)dtype -> Collectors$.MODULE$.mkColumnCtx((String)dtype._2(), maxNumRows), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Collectors.ColumnCtx.class)));
        IntRef numRows = IntRef.create((int)0);
        while (iter.hasNext() && numRows.elem < maxNumRows) {
            Row row = (Row)iter.next();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dtypes.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)colIdx -> columns[colIdx].collect(row, colIdx, numRows$1.elem));
            ++numRows.elem;
        }
        return this.toArray((Iterable<Collectors.ColumnCtx<?>>)Predef$.MODULE$.wrapRefArray((Object[])columns), numRows.elem, separator);
    }

    private Object collectColumns(Row[] local, Tuple2<String, String>[] dtypes, String separator) {
        int numRows = local.length;
        Collectors.ColumnCtx[] columns = (Collectors.ColumnCtx[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dtypes)).map((Function1 & Serializable & scala.Serializable)dtype -> Collectors$.MODULE$.mkColumnCtx((String)dtype._2(), numRows), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Collectors.ColumnCtx.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dtypes.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)colIdx -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rowIdx -> columns[colIdx].collect(local[rowIdx], colIdx, rowIdx)));
        return this.toArray((Iterable<Collectors.ColumnCtx<?>>)Predef$.MODULE$.wrapRefArray((Object[])columns), numRows, separator);
    }

    private Object toArray(Iterable<Collectors.ColumnCtx<?>> columns, int numRows, String separator) {
        Function2[] StringCollectors = (Function2[])((Object[])new Function2[]{Collectors$.MODULE$.collectString(), Collectors$.MODULE$.collectForceString()});
        Object[] res = (Object[])((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)x -> {
            String str;
            Object column = Predef$.MODULE$.genericArrayOps(x.column()).take(numRows);
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StringCollectors)).contains(x.collector()) ? ((str = Predef$.MODULE$.genericArrayOps(column).mkString(separator)).isEmpty() ? str : new StringBuilder(0).append(str).append(separator).toString()) : column;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        return res;
    }

    public Dataset<Row> separateColumnArray(Dataset<Row> df, String column, String[] names, int[] indices) {
        ObjectRef col = ObjectRef.create((Object)df.apply(column));
        ObjectRef colexprs = ObjectRef.create((Object)((Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)x$3 -> df.apply(x$3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), names.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String name = names[i];
            int index = indices[i];
            colexprs$1.elem = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Column[])colexprs$1.elem))).$colon$plus((Object)((Column)col$1.elem).getItem((Object)BoxesRunTime.boxToInteger((int)index)).as(name), ClassTag$.MODULE$.apply(Column.class));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Column[])colexprs.elem)));
    }

    public Dataset<Row> separateColumnVector(Dataset<Row> df, String column, String[] names, int[] indices) {
        ObjectRef col = ObjectRef.create((Object)df.apply(column));
        ObjectRef colexprs = ObjectRef.create((Object)((Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)x$4 -> df.apply(x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        UserDefinedFunction extractor = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, i) -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$separateColumnVector$2(x, BoxesRunTime.unboxToInt((Object)i))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), names.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String name = names[i];
            int index = indices[i];
            colexprs$2.elem = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Column[])colexprs$2.elem))).$colon$plus((Object)extractor.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)col$2.elem, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)index))})).as(name), ClassTag$.MODULE$.apply(Column.class));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Column[])colexprs.elem)));
    }

    public Dataset<Row> separateColumnStruct(Dataset<Row> df, String column, String[] names, int[] indices, boolean intoIsSet) {
        ObjectRef col = ObjectRef.create((Object)df.apply(column));
        ObjectRef colexprs = ObjectRef.create((Object)((Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)x$5 -> df.apply(x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        String[] fieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select(column, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).schema().fields())).flatMap((Function1 & Serializable & scala.Serializable)f -> new ArrayOps.ofRef(Utils$.$anonfun$separateColumnStruct$2(f)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] outNames = intoIsSet ? names : fieldNames;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outNames.length).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String name = outNames[i];
            int index = indices[i];
            colexprs$3.elem = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Column[])colexprs$3.elem))).$colon$plus((Object)((Column)col$3.elem).getItem((Object)fieldNames[index]).as(name), ClassTag$.MODULE$.apply(Column.class));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Column[])colexprs.elem)));
    }

    public Dataset<Row> separateColumn(Dataset<Row> df, String column, String[] names, int[] indices, boolean intoIsSet) {
        Dataset<Row> dataset;
        Column col = df.apply(column);
        StructType schema = df.schema();
        String typeName = schema.apply(schema.fieldIndex(column)).dataType().typeName();
        String string = typeName;
        if ("array".equals(string)) {
            dataset = this.separateColumnArray(df, column, names, indices);
        } else if ("vector".equals(string)) {
            dataset = this.separateColumnVector(df, column, names, indices);
        } else if ("struct".equals(string)) {
            dataset = this.separateColumnStruct(df, column, names, indices, intoIsSet);
        } else {
            throw new IllegalArgumentException(new StringBuilder(17).append("unhandled type '").append(typeName).append("'").toString());
        }
        return dataset;
    }

    public RDD<InternalRow> parallelize(SparkContext sc, int num_rows, byte[][] serialized_cols, Seq<Object> timestamp_col_idxes, Seq<Object> string_col_idxes, int partitions) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serialized_cols)).isEmpty()) {
            throw new IllegalArgumentException("Serialized columns byte array is empty.");
        }
        Object[][] cols = (Object[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serialized_cols)).map((Function1 & Serializable & scala.Serializable)serialized_col -> {
            ByteArrayInputStream bis = new ByteArrayInputStream((byte[])serialized_col);
            DataInputStream dis = new DataInputStream(bis);
            RUtils$.MODULE$.validateSerializationFormat(dis, RUtils$.MODULE$.validateSerializationFormat$default$2());
            return RUtils$.MODULE$.unserializeColumn(dis);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)))))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
        int num_cols = cols.length;
        timestamp_col_idxes.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)c -> {
            cols$1[c] = (Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.genericArrayOps((Object)cols[c]).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)Utils$.$anonfun$parallelize$3(x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toArray(ClassTag$.MODULE$.Any());
        });
        string_col_idxes.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)c -> {
            cols$1[c] = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)cols[c]).map((Function1 & Serializable & scala.Serializable)x -> UTF8String.fromString((String)((String)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UTF8String.class))))).toArray(ClassTag$.MODULE$.Any());
        });
        UnsafeRow[] rows = (UnsafeRow[])((ParIterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num_rows).par().map((Function1 & Serializable & scala.Serializable)r -> Utils$.$anonfun$parallelize$6(num_cols, cols, BoxesRunTime.unboxToInt((Object)r)), (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
        RDD x = sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])rows), partitions, ClassTag$.MODULE$.apply(InternalRow.class));
        return x;
    }

    private int writeVariableLengthField(int variableLengthOffset, UnsafeRow row, int ordinal, byte[] buf) {
        row.setLong(ordinal, (long)variableLengthOffset << 32 | (long)buf.length);
        Platform.copyMemory((Object)buf, (long)Platform.BYTE_ARRAY_OFFSET, (Object)row.getBaseObject(), (long)(row.getBaseOffset() + (long)variableLengthOffset), (long)buf.length);
        return variableLengthOffset + buf.length;
    }

    public RDD<Row> createDataFrame(SparkContext sc, Object rows, int partitions) {
        Row[] data = (Row[])Predef$.MODULE$.genericArrayOps(rows).map((Function1 & Serializable & scala.Serializable)o -> {
            Object r = o;
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray(r));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        return sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])data), partitions, ClassTag$.MODULE$.apply(Row.class));
    }

    public boolean classExists(String name) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Class.forName(name)).isSuccess();
    }

    public Dataset<Row> addSequentialIndex(Dataset<Row> df, int from, String id) {
        SQLContext sqlContext = df.sqlContext();
        return sqlContext.createDataFrame(df.rdd().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long i;
            Row row;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    row = (Row)tuple2._1();
                    i = tuple2._2$mcJ$sp();
                    if (row != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Row row2 = row;
            long l = i;
            Row row3 = Row$.MODULE$.fromSeq((Seq)row2.toSeq().$colon$plus((Object)BoxesRunTime.boxToDouble((double)((double)l + (double)from)), Seq$.MODULE$.canBuildFrom()));
            return row3;
        }, ClassTag$.MODULE$.apply(Row.class)), df.schema().add(id, "double"));
    }

    public double getLastIndex(Dataset<Row> df, String id) {
        int numPartitions = df.rdd().partitions().length;
        RDD qual$1 = df.select(id, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd();
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(i, iter) -> Utils$.$anonfun$getLastIndex$1(numPartitions, BoxesRunTime.unboxToInt((Object)i), iter);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        return ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)).collect())).last()).getDouble(0);
    }

    public String unboxString(Option<String> x) {
        String string;
        Option<String> option = x;
        if (option instanceof Some) {
            String s;
            Some some = (Some)option;
            string = s = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String[] getAncestry(Object obj, boolean simpleName) {
        return (String[])((TraversableOnce)Utils$.supers$1(obj.getClass()).map((Function1)(simpleName ? (Function1 & Serializable & scala.Serializable)x$8 -> x$8.getSimpleName() : (Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean getAncestry$default$2() {
        return true;
    }

    public boolean portIsAvailable(int port, InetAddress inetAddress) {
        ObjectRef ss = ObjectRef.create(null);
        BooleanRef available = BooleanRef.create((boolean)false);
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ss$1.elem = new ServerSocket(port, 1, inetAddress);
            available$1.elem = true;
        });
        Object object = (ServerSocket)ss.elem != null ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ServerSocket)ss$1.elem).close()) : BoxedUnit.UNIT;
        return available.elem;
    }

    public int nextPort(int port, InetAddress inetAddress) {
        int freePort = port + 1;
        while (!this.portIsAvailable(freePort, inetAddress) && freePort - port < 100) {
            ++freePort;
        }
        return freePort - port < 100 ? freePort : 0;
    }

    public StructType buildStructTypeForIntegerField() {
        StructField[] fields = (StructField[])((Object[])new StructField[]{new StructField("id", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())});
        return new StructType(fields);
    }

    public StructType buildStructTypeForLongField() {
        StructField[] fields = (StructField[])((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())});
        return new StructType(fields);
    }

    public RDD<Row> mapRddLongToRddRow(RDD<Object> rdd) {
        return rdd.map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x))})), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> mapRddIntegerToRddRow(RDD<Object> rdd) {
        return rdd.map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToLong((Object)x)))})), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> readWholeFiles(SparkContext sc, String inputPath) {
        return sc.wholeTextFiles(inputPath, sc.wholeTextFiles$default$2()).map((Function1 & Serializable & scala.Serializable)l -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l._1(), l._2()})), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> unionRdd(SparkContext context, Seq<RDD<Row>> rdds) {
        return context.union(rdds, ClassTag$.MODULE$.apply(Row.class));
    }

    public Object collectIter(Iterator<Row> iter, Object[] dtypes, int size, String separator) {
        return this.collectRows(iter, (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)dtypes).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toArray(ClassTag$.MODULE$.apply(Tuple2.class)), separator, size);
    }

    public Object extractValue(Row row, int colIdx) {
        DataType dtype = row.schema().fields()[colIdx].dataType();
        DataType dataType = dtype;
        Object object = dataType instanceof BooleanType ? BoxesRunTime.boxToBoolean((boolean)row.getBoolean(colIdx)) : (dataType instanceof ByteType ? BoxesRunTime.boxToByte((byte)row.getByte(colIdx)) : (dataType instanceof ShortType ? BoxesRunTime.boxToShort((short)row.getShort(colIdx)) : (dataType instanceof IntegerType ? BoxesRunTime.boxToInteger((int)row.getInt(colIdx)) : (dataType instanceof LongType ? BoxesRunTime.boxToLong((long)row.getLong(colIdx)) : (dataType instanceof FloatType ? BoxesRunTime.boxToFloat((float)row.getFloat(colIdx)) : (dataType instanceof DoubleType ? BoxesRunTime.boxToDouble((double)row.getDouble(colIdx)) : (dataType instanceof DecimalType ? row.getDecimal(colIdx) : (dataType instanceof StringType ? row.getString(colIdx) : (dataType instanceof BinaryType ? row.getAs(colIdx) : (dataType instanceof TimestampType ? row.getTimestamp(colIdx) : (dataType instanceof DateType ? row.getDate(colIdx) : (dataType instanceof ArrayType ? row.getAs(colIdx) : (dataType instanceof MapType ? row.getAs(colIdx) : (dataType instanceof StructType ? row.getAs(colIdx) : row.getString(colIdx)))))))))))))));
        return object;
    }

    public Function1<Object, Object> as(DataType dtype) {
        return (Function1 & Serializable & scala.Serializable)value -> {
            DataType dataType = dtype;
            Object object = dataType instanceof ByteType ? BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)value)) : (dataType instanceof ShortType ? BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)value)) : (dataType instanceof IntegerType ? BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value)) : (dataType instanceof LongType ? BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)value)) : (dataType instanceof FloatType ? BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)value)) : (dataType instanceof DoubleType ? BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value)) : (dataType instanceof DecimalType ? (BigDecimal)value : (dataType instanceof StringType ? (String)value : (dataType instanceof BinaryType ? (Object)((byte[])value) : (dataType instanceof TimestampType ? (Timestamp)value : (dataType instanceof DateType ? (java.sql.Date)value : (dataType instanceof ArrayType ? (Seq)value : (dataType instanceof MapType ? (Map)value : (dataType instanceof StructType ? (Row)value : (String)value)))))))))))));
            return object;
        };
    }

    public double asDouble(Object x) {
        double d;
        Object object = x;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            d = Predef$.MODULE$.byte2Byte(by).doubleValue();
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            d = Predef$.MODULE$.short2Short(s).doubleValue();
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            d = n;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            d = l;
        } else if (object instanceof Double) {
            double d2;
            d = d2 = BoxesRunTime.unboxToDouble((Object)object);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            d = f;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            d = bigDecimal.doubleValue();
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            d = timestamp.getTime();
        } else if (object instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)object;
            d = date.getTime();
        } else if (object instanceof Date) {
            Date date = (Date)object;
            d = date.getTime();
        } else {
            d = Double.NaN;
        }
        return d;
    }

    public long asLong(Object x) {
        long l;
        Object object = x;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            l = by;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            l = s;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            l = n;
        } else if (object instanceof Long) {
            long l2;
            l = l2 = BoxesRunTime.unboxToLong((Object)object);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            l = (long)f;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            l = (long)d;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            l = bigDecimal.longValue();
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            l = timestamp.getTime();
        } else if (object instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)object;
            l = date.getTime();
        } else if (object instanceof Date) {
            Date date = (Date)object;
            l = date.getTime();
        } else {
            throw new IllegalArgumentException("unsupported input type");
        }
        return l;
    }

    public Properties setProperties(Seq<String> keys, Seq<String> values) {
        return this.setProperties(new Properties(), keys, values);
    }

    public Properties setProperties(Properties x, Seq<String> keys, Seq<String> values) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), keys.length()).foreach((Function1 & Serializable & scala.Serializable)i -> x.setProperty((String)keys.apply(BoxesRunTime.unboxToInt((Object)i)), (String)values.apply(BoxesRunTime.unboxToInt((Object)i))));
        return x;
    }

    public static final /* synthetic */ double $anonfun$separateColumnVector$2(Object x, int i) {
        Object el = x.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(x, new Object[0]);
        double[] array = (double[])el;
        return array[i];
    }

    public static final /* synthetic */ Object[] $anonfun$separateColumnStruct$2(StructField f) {
        DataType dataType = f.dataType();
        if (!(dataType instanceof StructType)) {
            throw new MatchError((Object)dataType);
        }
        StructType structType = (StructType)dataType;
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])structType.fields());
        return objectArray;
    }

    public static final /* synthetic */ long $anonfun$parallelize$3(Object x) {
        return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)x)).longValue() * 1000000L;
    }

    public static final /* synthetic */ UnsafeRow $anonfun$parallelize$6(int num_cols$1, Object[][] cols$1, int r) {
        int variableLengthBytes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num_cols$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)c -> {
            int n;
            Object object = cols$1[c][r];
            if (object instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)object;
                n = uTF8String.numBytes();
            } else if (object instanceof RawSXP) {
                RawSXP rawSXP = (RawSXP)object;
                n = rawSXP.buf().length;
            } else {
                n = 0;
            }
            return n;
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef variableLengthOffset = IntRef.create((int)(UnsafeRow.calculateBitSetWidthInBytes((int)cols$1.length) + 8 * num_cols$1));
        UnsafeRow row = UnsafeRow.createFromByteArray((int)(variableLengthOffset.elem + variableLengthBytes), (int)num_cols$1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num_cols$1).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)c -> {
            if (cols$1[c][r] == null) {
                row.setNullAt(c);
            } else {
                Object object = cols$1[c][r];
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    row.setBoolean(c, bl);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    row.setInt(c, Predef$.MODULE$.Integer2int(n));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    row.setDouble(c, d);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    row.setLong(c, l);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)object;
                    variableLengthOffset$1.elem = MODULE$.writeVariableLengthField(variableLengthOffset$1.elem, row, c, uTF8String.getBytes());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof RawSXP) {
                    RawSXP rawSXP = (RawSXP)object;
                    variableLengthOffset$1.elem = MODULE$.writeVariableLengthField(variableLengthOffset$1.elem, row, c, rawSXP.buf());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new IllegalArgumentException("Unsupported column type");
                }
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return row;
    }

    public static final /* synthetic */ Iterator $anonfun$getLastIndex$1(int numPartitions$1, int i, Iterator iter) {
        return i != numPartitions$1 - 1 || iter.isEmpty() ? iter : scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> new Tuple2(iter.next(), (Object)BoxesRunTime.boxToBoolean((boolean)iter.hasNext()))).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Row, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Row value = (Row)A1._1();
                    boolean bl = A1._2$mcZ$sp();
                    if (!bl) {
                        object = value;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Row, Object> x1) {
                boolean bl;
                Tuple2<Row, Object> tuple2 = x1;
                boolean bl2 = tuple2 != null && !(bl = tuple2._2$mcZ$sp());
                return bl2;
            }
        }).take(1);
    }

    private static final List supers$1(Class cl) {
        Nil$ nil$;
        if (cl == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Class clazz = cl;
            nil$ = Utils$.supers$1(cl.getSuperclass()).$colon$colon((Object)clazz);
        }
        return nil$;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

