/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.util.matching.Regex;
import sparklyr.Collectors;
import sparklyr.DaysSinceEpoch;
import sparklyr.Numeric;
import sparklyr.StructTypeAsJSON;
import sparklyr.StructTypeAsJSON$;

public final class Collectors$ {
    public static Collectors$ MODULE$;
    private final Regex ReDecimalType;
    private final Regex ReVectorType;
    private final Regex ReBooleanArrayType;
    private final Regex ReByteArrayType;
    private final Regex ReShortArrayType;
    private final Regex ReIntegerArrayType;
    private final Regex ReLongArrayType;
    private final Regex ReDecimalArrayType;
    private final Regex ReFloatArrayType;
    private final Regex ReDoubleArrayType;
    private final Regex ReStringArrayType;
    private final Regex ReTimestampArrayType;
    private final Regex ReDateArrayType;
    private final Function2<Row, Object, String> collectForceString;
    private final Function2<Row, Object, String> collectString;

    static {
        new Collectors$();
    }

    public Regex ReDecimalType() {
        return this.ReDecimalType;
    }

    public Regex ReVectorType() {
        return this.ReVectorType;
    }

    public Regex ReBooleanArrayType() {
        return this.ReBooleanArrayType;
    }

    public Regex ReByteArrayType() {
        return this.ReByteArrayType;
    }

    public Regex ReShortArrayType() {
        return this.ReShortArrayType;
    }

    public Regex ReIntegerArrayType() {
        return this.ReIntegerArrayType;
    }

    public Regex ReLongArrayType() {
        return this.ReLongArrayType;
    }

    public Regex ReDecimalArrayType() {
        return this.ReDecimalArrayType;
    }

    public Regex ReFloatArrayType() {
        return this.ReFloatArrayType;
    }

    public Regex ReDoubleArrayType() {
        return this.ReDoubleArrayType;
    }

    public Regex ReStringArrayType() {
        return this.ReStringArrayType;
    }

    public Regex ReTimestampArrayType() {
        return this.ReTimestampArrayType;
    }

    public Regex ReDateArrayType() {
        return this.ReDateArrayType;
    }

    public int collectBoolean(Row row, int idx) {
        return this.extractBoolean(row.apply(idx));
    }

    public int[] collectBooleanArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.extractBoolean(x)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    private int extractBoolean(Object x) {
        int n;
        Object object = x;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            n = new RichBoolean(Predef$.MODULE$.booleanWrapper(bl)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    public <T> int collectIntegralType(Row row, int idx, Integral<T> evidence$1, ClassTag<T> t) {
        return this.extractIntegralType(row.apply(idx), evidence$1, t);
    }

    public <T> int[] collectIntegralTypeArr(Row row, int idx, Integral<T> evidence$2, ClassTag<T> t) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.extractIntegralType(x, evidence$2, t)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    private <T> int extractIntegralType(Object x, Integral<T> evidence$3, ClassTag<T> t) {
        Object object = x;
        Option option = t.unapply(object);
        int n = !option.isEmpty() && option.get() instanceof Object ? ((scala.math.Numeric)Predef$.MODULE$.implicitly(evidence$3)).toInt(object) : Integer.MIN_VALUE;
        return n;
    }

    public <T> Numeric collectNumericType(Row row, int idx, scala.math.Numeric<T> evidence$4, ClassTag<T> t) {
        return this.extractNumericType(row.apply(idx), evidence$4, t);
    }

    public <T> Numeric[] collectNumericTypeArr(Row row, int idx, scala.math.Numeric<T> evidence$5, ClassTag<T> t) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Numeric[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractNumericType(x, evidence$5, t), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    private <T> Numeric extractNumericType(Object x, scala.math.Numeric<T> evidence$6, ClassTag<T> t) {
        None$ none$;
        if (x == null) {
            none$ = None$.MODULE$;
        } else {
            Object object = x;
            Option option = t.unapply(object);
            Some some = !option.isEmpty() && option.get() instanceof Object ? new Some((Object)BoxesRunTime.boxToDouble((double)((scala.math.Numeric)Predef$.MODULE$.implicitly(evidence$6)).toDouble(object))) : new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
            none$ = some;
        }
        return new Numeric((Option<Object>)none$);
    }

    public Numeric collectBigDecimal(Row row, int idx) {
        return this.extractBigDecimal(row.apply(idx));
    }

    public Numeric[] collectBigDecimalArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Numeric[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractBigDecimal(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    private Numeric extractBigDecimal(Object x) {
        None$ none$;
        if (x == null) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            Object object = x;
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                some = new Some((Object)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()));
            } else {
                some = new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
            }
            none$ = some;
        }
        return new Numeric((Option<Object>)none$);
    }

    public Function2<Row, Object, String> collectForceString() {
        return this.collectForceString;
    }

    public String[] collectForceStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (String[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractStringRepr(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String extractStringRepr(Object x) {
        return x == null ? "<NA>" : x.toString();
    }

    public Function2<Row, Object, String> collectString() {
        return this.collectString;
    }

    public String[] collectStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (String[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractString(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String extractString(Object x) {
        String string;
        Object object = x;
        String string2 = object instanceof String ? (string = (String)object) : "<NA>";
        return string2;
    }

    public Object collectVector(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el;
        Object object2 = object == null ? Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing()) : (object instanceof Seq ? ((Seq)el).toArray(ClassTag$.MODULE$.Any()) : el.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(el, new Object[0]));
        return object2;
    }

    public Object collectJSON(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el;
        Object object2 = object instanceof String ? new StructTypeAsJSON((String)el) : this.collectDefault(row, idx);
        return object2;
    }

    public Timestamp collectTimestamp(Row row, int idx) {
        return this.extractTimestamp(row.apply(idx));
    }

    public Timestamp[] collectTimestampArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (Timestamp[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractTimestamp(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    private Timestamp extractTimestamp(Object x) {
        Timestamp timestamp;
        Object object = x;
        Timestamp timestamp2 = object instanceof Timestamp ? (timestamp = (Timestamp)object) : null;
        return timestamp2;
    }

    public DaysSinceEpoch collectDate(Row row, int idx) {
        return this.extractDaysSinceEpoch(row.apply(idx));
    }

    public DaysSinceEpoch extractDaysSinceEpoch(Object x) {
        None$ none$;
        Object object = x;
        if (object instanceof Date) {
            Date date = (Date)object;
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date)));
        } else {
            none$ = None$.MODULE$;
        }
        return new DaysSinceEpoch((Option<Object>)none$);
    }

    public DaysSinceEpoch[] collectDateArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (DaysSinceEpoch[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.extractDaysSinceEpoch(x), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DaysSinceEpoch.class)))).toArray(ClassTag$.MODULE$.apply(DaysSinceEpoch.class));
    }

    public Object collectDefault(Row row, int idx) {
        return row.apply(idx);
    }

    public Collectors.ColumnCtx<? super int[]> mkColumnCtx(String colType, int numRows) {
        Collectors.ColumnCtx columnCtx;
        String string = colType;
        if ("BooleanType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectBoolean(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("ByteType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectIntegralType(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ByteIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("ShortType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectIntegralType(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ShortIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Short())), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("IntegerType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectIntegralType(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.IntIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int())), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("LongType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericType(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Long()), ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
        } else if ("Decimal".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
        } else {
            Option option = this.ReDecimalType().unapplySeq((CharSequence)string);
            if (!option.isEmpty()) {
                columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBigDecimal(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
            } else if ("FloatType".equals(string)) {
                columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericType(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Float()), ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
            } else if ("DoubleType".equals(string)) {
                columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericType(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()), ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
            } else if ("StringType".equals(string)) {
                columnCtx = Collectors$.newColumnCtx$1(this.collectString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
            } else if ("TimestampType".equals(string)) {
                columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestamp(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Timestamp.class), numRows);
            } else if ("CalendarIntervalType".equals(string)) {
                columnCtx = Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
            } else if ("DateType".equals(string)) {
                columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDate(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(DaysSinceEpoch.class), numRows);
            } else {
                Option option2 = this.ReVectorType().unapplySeq((CharSequence)string);
                if (!option2.isEmpty()) {
                    columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectVector(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), numRows);
                } else {
                    Option option3;
                    Option option4;
                    Option option5;
                    Option option6;
                    Option option7;
                    Option option8;
                    Option option9;
                    Option option10;
                    Option option11;
                    Option option12;
                    Option option13;
                    String string2 = StructTypeAsJSON$.MODULE$.DType();
                    String string3 = string;
                    columnCtx = !(string2 != null ? !string2.equals(string3) : string3 != null) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectJSON(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), numRows) : (!(option13 = this.ReBooleanArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBooleanArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : (!(option12 = this.ReByteArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegralTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ByteIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : (!(option11 = this.ReShortArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegralTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.ShortIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Short()), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : (!(option10 = this.ReIntegerArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegralTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (Integral)Numeric.IntIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : (!(option9 = this.ReLongArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$, (ClassTag)ClassTag$.MODULE$.Long()), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows) : (!(option8 = this.ReDecimalArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBigDecimalArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows) : (!(option7 = this.ReFloatArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Float()), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows) : (!(option6 = this.ReDoubleArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericTypeArr(row, BoxesRunTime.unboxToInt((Object)idx), (scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows) : (!(option5 = this.ReStringArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : (!(option4 = this.ReTimestampArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestampArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Timestamp.class)), numRows) : (!(option3 = this.ReDateArrayType().unapplySeq((CharSequence)string)).isEmpty() ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDateArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(DaysSinceEpoch.class)), numRows) : ("ArrayType(CalendarIntervalType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectForceStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("ArrayType(CalendarIntervalType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectForceStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("NullType".equals(string) ? Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows) : Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDefault(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), numRows)))))))))))))));
                }
            }
        }
        return columnCtx;
    }

    private static final Collectors.ColumnCtx newColumnCtx$1(Function2 collector, Manifest evidence$8, int numRows$1) {
        return new Collectors.ColumnCtx(collector, numRows$1, evidence$8);
    }

    private Collectors$() {
        MODULE$ = this;
        this.ReDecimalType = new StringOps(Predef$.MODULE$.augmentString("(^DecimalType(\\(.*\\)?)$)")).r();
        this.ReVectorType = new StringOps(Predef$.MODULE$.augmentString("(.*VectorUDT.*)")).r();
        this.ReBooleanArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(BooleanType,(true|false)\\)$)")).r();
        this.ReByteArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(ByteType,(true|false)\\)$)")).r();
        this.ReShortArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(ShortType,(true|false)\\)$)")).r();
        this.ReIntegerArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(IntegerType,(true|false)\\)$)")).r();
        this.ReLongArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(LongType,(true|false)\\)$)")).r();
        this.ReDecimalArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(DecimalType(\\(.*\\)?),(true|false)\\)$)")).r();
        this.ReFloatArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(FloatType,(true|false)\\)$)")).r();
        this.ReDoubleArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(DoubleType,(true|false)\\)$)")).r();
        this.ReStringArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(StringType,(true|false)\\)$)")).r();
        this.ReTimestampArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(TimestampType,(true|false)\\)$)")).r();
        this.ReDateArrayType = new StringOps(Predef$.MODULE$.augmentString("(^ArrayType\\(DateType,(true|false)\\)$)")).r();
        this.collectForceString = (Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.extractStringRepr(row.apply(BoxesRunTime.unboxToInt((Object)idx)));
        this.collectString = (Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.extractString(row.apply(BoxesRunTime.unboxToInt((Object)idx)));
    }
}

