/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

public abstract class Format {
    private static final String systemLineSeparatorString;
    private static final char[] systemLineSeparator;
    private String lineSeparatorString;
    private char[] lineSeparator;
    private char normalizedNewline = (char)10;
    private char comment = (char)35;

    protected Format() {
        this.lineSeparator = (char[])systemLineSeparator.clone();
        this.lineSeparatorString = systemLineSeparatorString;
    }

    public char[] getLineSeparator() {
        return (char[])this.lineSeparator.clone();
    }

    public String getLineSeparatorString() {
        return this.lineSeparatorString;
    }

    public void setLineSeparator(String lineSeparator) {
        if (lineSeparator == null || lineSeparator.isEmpty()) {
            throw new IllegalArgumentException("Line separator cannot be empty");
        }
        this.setLineSeparator(lineSeparator.toCharArray());
    }

    public void setLineSeparator(char[] lineSeparator) {
        if (lineSeparator == null || lineSeparator.length == 0) {
            throw new IllegalArgumentException("Invalid line separator. Expected 1 to 2 characters");
        }
        if (lineSeparator.length > 2) {
            throw new IllegalArgumentException("Invalid line separator. Up to 2 characters are expected. Got " + lineSeparator.length + " characters.");
        }
        this.lineSeparator = lineSeparator;
        this.lineSeparatorString = new String(lineSeparator);
    }

    public char getNormalizedNewline() {
        return this.normalizedNewline;
    }

    public void setNormalizedNewline(char normalizedNewline) {
        this.normalizedNewline = normalizedNewline;
    }

    public boolean isNewLine(char ch) {
        return this.normalizedNewline == ch;
    }

    public char getComment() {
        return this.comment;
    }

    public void setComment(char comment) {
        this.comment = comment;
    }

    public boolean isComment(char ch) {
        return this.comment == ch;
    }

    static {
        String lineSeparator = System.getProperty("line.separator");
        systemLineSeparatorString = lineSeparator == null ? "\n" : lineSeparator;
        systemLineSeparator = systemLineSeparatorString.toCharArray();
    }
}

