% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explode.R
\name{sdf_explode}
\alias{sdf_explode}
\title{Explode data along a column}
\usage{
sdf_explode(x, column, is_map = FALSE, keep_all = FALSE)
}
\arguments{
\item{x}{An object (usually a \code{spark_tbl}) coercible to a Spark DataFrame.}

\item{column}{The field to explode}

\item{is_map}{Logical. The (scala) \code{explode} method works for both \code{array} and \code{map}
column types. If the column to explode in an array, then \code{is_map=FALSE} will ensure that
the exploded output retains the name of the array column. If however the column to explode is
a map, then the map will have key/value names that will be used if \code{is_map=TRUE}.}

\item{keep_all}{Logical. If \code{FALSE} then records where the exploded value is empty/null
will be dropped.}
}
\description{
Exploding an array column of length \code{N} will replicate the top level record \code{N} times.
The ith replicated record will contain a struct (not an array) corresponding to the ith element
of the exploded array. Exploding will not promote any fields or otherwise change the schema of
the data.
}
\details{
Two types of exploding are possible. The default method calls the scala \code{explode} method.
This operation is supported in both Spark version > 1.6. It will however drop records where the
exploding field is empty/null. Alternatively \code{keep_all=TRUE} will use the \code{explode_outer}
scala method introduced in spark 2 to not drop any records.
}
\examples{
\dontrun{
# first get some nested data
iris2 <- copy_to(sc, iris, name="iris")
iris_nst <- iris2 \%>\%
  sdf_nest(Sepal_Length, Sepal_Width, Petal_Length, Petal_Width, .key="data") \%>\%
  group_by(Species) \%>\%
  summarize(data=collect_list(data))

# then explode it
iris_nst \%>\% sdf_explode(data)
}
}
