% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{fit_mrs}
\alias{fit_mrs}
\title{Perform a fit based analysis of MRS data.}
\usage{
fit_mrs(metab, basis, method = "VARPRO", w_ref = NULL, opts = NULL,
  parallel = FALSE, cores = 4)
}
\arguments{
\item{metab}{Metabolite data.}

\item{basis}{A basis class object or character vector to basis file in
LCModel .basis format.}

\item{method}{'VARPRO', 'VARPRO_3P', 'TARQUIN' or 'LCMODEL'}

\item{w_ref}{Water reference data for concentration scaling (optional).}

\item{opts}{Options to pass to the analysis method.}

\item{parallel}{Perform analysis in parallel (TRUE or FALSE)}

\item{cores}{Number of cores to use for parallel analysis.}
}
\value{
MRS analysis object.
}
\description{
Note that TARQUIN and LCModel require these packages to be installed, and
the functions set_tqn_path and set_lcm_path (respectively) need to be used
to specify the location of these software packages.
}
\details{
Fitting approaches described in the following references:
VARPRO
van der Veen JW, de Beer R, Luyten PR, van Ormondt D. Accurate quantification
of in vivo 31P NMR signals using the variable projection method and prior
knowledge. Magn Reson Med 1988;6:92-98

TARQUIN
Wilson, M., Reynolds, G., Kauppinen, R. A., Arvanitis, T. N. & Peet, A. C.
A constrained least-squares approach to the automated quantitation of in vivo
1H magnetic resonance spectroscopy data. Magn Reson Med 2011;65:1-12.

LCModel
Provencher SW. Estimation of metabolite concentrations from localized in vivo
proton NMR spectra. Magn Reson Med 1993;30:672-679.
}
\examples{
fname <- system.file("extdata","philips_spar_sdat_WS.SDAT",package="spant")
svs <- read_mrs(fname, format="spar_sdat")
\dontrun{
basis <- sim_basis_1h_brain_press(svs)
fit_result <- fit_mrs(svs, basis)
}
}
