% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacy_langmodel_functions.R
\name{spacy_download_langmodel}
\alias{spacy_download_langmodel}
\alias{spacy_download_langmodel_virtualenv}
\title{Install a language model in a conda or virtual environment}
\usage{
spacy_download_langmodel(
  model = "en",
  envname = "spacy_condaenv",
  conda = "auto"
)

spacy_download_langmodel_virtualenv(
  model = "en",
  envname = "spacy_virtualenv",
  virtualenv_root = NULL
)
}
\arguments{
\item{model}{name of the language model to be installed.  A list of available
language models and their names is available from the
\href{https://spacy.io/usage/models}{spaCy language models} page.}

\item{envname}{name of the virtual environment}

\item{conda}{Path to conda executable.  Default \code{"auto"} which
automatically finds the path.}

\item{virtualenv_root}{path to the virtualenv environment to install spaCy
language model. If \code{NULL}, the default path \code{"~/.virtualenvs"}
will be used.}
}
\description{
Installs one or more language models in a conda or virtualenv Python virtual
environment as installed by \code{\link{spacy_install}}.
}
