% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.R
\name{multiview}
\alias{multiview}
\alias{multiview,sf-method}
\alias{multiview,SpatRaster-method}
\title{multiview embedding forecast}
\usage{
\S4method{multiview}{sf}(
  data,
  columns,
  target,
  nvar,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  nb = NULL,
  top = NULL,
  threads = detectThreads(),
  trend.rm = TRUE
)

\S4method{multiview}{SpatRaster}(
  data,
  columns,
  target,
  nvar,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  top = NULL,
  threads = detectThreads(),
  trend.rm = TRUE
)
}
\arguments{
\item{data}{The observation data.}

\item{columns}{Names of individual variables.}

\item{target}{Name of target variable.}

\item{nvar}{Number of variable combinations.}

\item{lib}{(optional) Libraries indices.}

\item{pred}{(optional) Predictions indices.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors used in prediction.}

\item{nb}{(optional) The neighbours list.}

\item{top}{(optional) Number of reconstructions used in MVE forecast.}

\item{threads}{(optional) Number of threads.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}
}
\value{
A vector (when input is sf object) or matrix
}
\description{
multiview embedding forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
multiview(columbus,
          columns = c("inc","crime","open","plumb","discbd"),
          target = "hoval", nvar = 3)
}
}
\references{
Ye H., and G. Sugihara, 2016. Information leverage in interconnected ecosystems: Overcoming the curse of dimensionality. Science 353:922-925.
}
