% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{getDom}
\alias{getDom}
\title{Get lowest dominant frequency band}
\usage{
getDom(frame, samplingRate, bin, domSmooth, domThres, pitchFloor, pitchCeiling)
}
\arguments{
\item{frame}{the real part of the spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{samplingRate}{sampling rate (Hz)}

\item{bin}{the width of one bin in spectrogram, Hz}

\item{domSmooth}{the width of smoothing interval (Hz) for finding
\code{dom}}

\item{domThres}{(0 to 1) to find the lowest dominant frequency band, we
do short-term FFT and take the lowest frequency with amplitude at least
domThres}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}
}
\value{
Returns a list of $dom (NA or numeric) and $dom_array
  (either NULL or a dataframe of pitch candidates).
}
\description{
Internal soundgen function.
}
\details{
Calculate the lowest frequency band in the spectrum above pitchFloor whose
power exceeds a certain threshold.
}
\keyword{internal}
