% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{crossFade}
\alias{crossFade}
\title{Join two waveforms by cross-fading}
\usage{
crossFade(ampl1, ampl2, crossLenPoints = 240, crossLen = NULL,
  samplingRate = NULL, shape = c("lin", "exp", "log", "cos", "logistic")[1],
  steepness = 1)
}
\arguments{
\item{ampl1, ampl2}{two numeric vectors (waveforms) to be joined}

\item{crossLenPoints}{(optional) the length of overlap in points}

\item{crossLen}{the length of overlap in ms (overrides crossLenPoints)}

\item{samplingRate}{the sampling rate of input vectors, Hz (needed only if
crossLen is given in ms rather than points)}

\item{shape}{controls the type of fade function: 'lin' = linear, 'exp' =
exponential, 'log' = logarithmic, 'cos' = cosine, 'logistic' = logistic
S-curve}

\item{steepness}{scaling factor regulating the steepness of fading curves if
the shape is 'exp', 'log', or 'logistic' (0 = linear, >1 = steeper than
default)}
}
\value{
Returns a numeric vector.
}
\description{
\code{crossFade} joins two input vectors (waveforms) by cross-fading. It
truncates both input vectors, so that \code{ampl1} ends with a zero crossing
and \code{ampl2} starts with a zero crossing, both on an upward portion of
the soundwave. Then it cross-fades both vectors linearly with an overlap of
crossLen or crossLenPoints. If the input vectors are too short for the
specified length of cross-faded region, the two vectors are concatenated at
zero crossings instead of cross-fading. Soundgen uses \code{crossFade} for
gluing together epochs with different regimes of pitch effects (see the
vignette on sound generation), but it can also be useful for joining two
separately generated sounds without audible artifacts.
}
\examples{
sound1 = sin(1:100 / 9)
sound2 = sin(7:107 / 3)
plot(c(sound1, sound2), type = 'b')
# an ugly discontinuity at 100 that will make an audible click

sound = crossFade(sound1, sound2, crossLenPoints = 5)
plot(sound, type = 'b') # a nice, smooth transition
length(sound) # but note that cross-fading costs us ~60 points
#  because of trimming to zero crossings and then overlapping

\dontrun{
# Actual sounds, alternative shapes of fade-in/out
sound3 = soundgen(formants = 'a', pitch = 200,
                  addSilence = 0, attackLen = c(50, 0))
sound4 = soundgen(formants = 'u', pitch = 200,
                  addSilence = 0, attackLen = c(0, 50))

# simple concatenation (with a click)
playme(c(sound3, sound4), 16000)

# concatentation from zc to zc (no click, but a rough transition)
playme(crossFade(sound3, sound4, crossLen = 0), 16000)

# linear crossFade over 35 ms - brief, but smooth
playme(crossFade(sound3, sound4, crossLen = 35, samplingRate = 16000), 16000)

# s-shaped cross-fade over 300 ms (shortens the sound by ~300 ms)
playme(crossFade(sound3, sound4, samplingRate = 16000,
                 crossLen = 300, shape = 'cos'), 16000)
}
}
