% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcription.R
\name{read.transcription}
\alias{read.transcription}
\title{Read transcription from a tsv file.}
\usage{
read.transcription(file, col.grapheme = "GRAPHEME", col.meta = "META",
  col.value = "VALUE")
}
\arguments{
\item{file}{[character] Path to the data file.}

\item{col.grapheme}{[character] Name of the column with graphemes. Defaults to \code{"GRAPHEME"}.}

\item{col.meta}{[character] Name of the column with the coverage of metacharacters. If empty string or NA, the column will be generated automatically. Defaults to \code{"META"}.}

\item{col.value}{[character] Name of the column with values of graphemes. Defaults to \code{"VALUE"}.}
}
\value{
[transcription] A transcription object containing the read transcription.
}
\description{
Read a table from file and create a \code{\link{transcription}} object out of it.
}
\details{
The constructor for the \code{\link{transcription}} class requires a data frame which means that the user would need to first read it from a file, and only then pass it to the constructor. This function saves this one step. In addition, it attaches the name of the file to the object, which allows for easier identification later. It is recommended to use \code{read.transcription} instead of the raw \code{\link{transcription}} constructor whenever possible.
}
\examples{
# path to a sample transcription
fName <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
read.transcription (fName)
}
\seealso{
\code{\link{transcription}}
}
