% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birdnetReticulate.R
\name{birdNetAnalyse}
\alias{birdNetAnalyse}
\title{Analyse sound files using BirdNET-Analyzer}
\usage{
birdNetAnalyse(
  files,
  lat = NULL,
  lon = NULL,
  date = NULL,
  output = "Annotation"
)
}
\arguments{
\item{files}{A character vector of file paths.}

\item{lat}{A latitude or  vector of latitudes.}

\item{lon}{A longitude or  vector of longitudes.}

\item{date}{A \code{Date} or list of \code{Date} objects .}

\item{output}{One of "data.frame" or "Annotation".}
}
\description{
This function takes a list of sound files and analyses them using the
\code{BirdNET-Analyzer} \insertCite{birdnet2021}{sonicscrewdriver}. The function
either returns a data frame with the results of the analysis or a list of
\code{Annotation} objects.
}
\examples{
\dontrun{
  birdnetAnalyse(files=c("path/to/file1.wav", "path/to/file2.wav"), output="data.frame")
}
}
\references{
\insertAllCited{}
}
