% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.R
\docType{package}
\name{som.nn-package}
\alias{som.nn}
\alias{som.nn-package}
\title{k-NN-like classification with self-organising maps}
\description{
The package \code{som.nn} provides tools to train self-organising maps
and predict class memberships by means of a k-NN-like classifier.
}
\details{
The functions \code{\link{som.nn.train}} and \code{\link{som.nn.continue}} are used 
train and re-train self-organising maps. Functions of the package 
\pkg{kohonen} are used for som training (see \code{\link[kohonen]{som}} for details).

In contrast to a normal som training, class lables are required for all
training samples. These class lables are used to assign classes to the
codebook vectors (i.e. the neurons of the map) and build a set of reference
vectors. This reference is used for nearest-neigbour classification.

The nearest neighbour classifier is implemented as predict method. 
It is controlled by the following parameters:
\itemize{
   \item \code{dist.fun}: the distance function to weight the distance of reference
         vectors and the sample to be predicted.
   \item \code{max.dist}: the maximum distance to be considered.
}
Some distance functions are provided in the package (linear, bubble, inverse 
and tricubic) but any custom function scan be defined as well.

The classifictaion differs from a normal nearest-neighbour classifier, because 
the neighbourhood is not defined by the distance between reference-vectors and 
sample-vectors. Instead the neighbourhood of the neurons on the som is used.

Because the som have been generated by an unsupervised training, the classifier is 
robust against overtraining.

In addition the abstract model can be visualised as 2-dimensional map, using
the plot method.
}

