% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{Object.get_or_upload_file}
\alias{Object.get_or_upload_file}
\title{Object.get_or_upload_file}
\usage{
Object.get_or_upload_file(local_path, vault_id, vault_path, filename,
  env = solvebio:::.solveEnv)
}
\arguments{
\item{local_path}{The path to the local file}

\item{vault_id}{The SolveBio vault ID}

\item{vault_path}{The remote path in the vault}

\item{filename}{(optional) The filename for the uploaded file in the vault (default: the basename of the local_path)}

\item{env}{(optional) Custom client environment.}
}
\description{
Upload a local file to a vault on SolveBio only if it does not yet exist (by name, at the provided path). The vault path provided is the parent directory for uploaded file. Accepts the same arguments as `Object.upload_file`.
}
\examples{
\dontrun{
Object.get_or_upload_file("my_file.json.gz", vault$id, "/parent/directory/")
}

}
\references{
\url{https://docs.solvebio.com/}
}
