% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCandidateMatrix.R
\name{createCandidateMatrix}
\alias{createCandidateMatrix}
\title{Create candidate matrix}
\usage{
createCandidateMatrix(data, statistics, pairs, crit)
}
\arguments{
\item{data}{The data.frame containing the observations, restructured as in
pairwiseSNHT.  So, the first column should be time, and the other columns
should be named with the locations and contain the observed values at each
location.}

\item{statistics}{The time x (number of pairs) matrix of SNHT statistics
computed for each difference series.}

\item{pairs}{The list object whose ith element specifies the neighboring
locations to the ith location.}

\item{crit}{The critical value such that if the snht statistic is larger
than crit, a changepoint is assumed to have occured.  Defaults to 100, as
recommended in Haimberger (see references).}
}
\value{
A matrix of dimension time x (number of locations).  The (i,j)
element of this matrix indicates the number of changepoints found in
difference series containing the jth location at time i.
}
\description{
This function creates candidate, a matrix where the (i,j)th entry
corresponds to the number of changepoints in difference series for location
j that occured at time i. For example, suppose location i_1 was paired with
i_2, i_3, and i_4.  If the statistic for i_1-i_2 and i_1-i_4 exceeded the
threshold at time j, then candidate_{i,j} = 2.
}

