% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_pars.R
\name{sk_to_string}
\alias{sk_to_string}
\title{Extract Kronecker covariance  parameters as plot-friendly strings}
\usage{
sk_to_string(pars, nsig = 3)
}
\arguments{
\item{pars}{character, character vector, or list (see details)}

\item{nsig}{number of significant figures to print}
}
\value{
a character string or list of them
}
\description{
Generate strings describing the model and parameter values in a Kronecker covariance
parameter list \code{pars}. These are used to fill out titles and axis labels in calls to
\code{sk_plot_pars}.
}
\details{
If \code{pars} is a parameter list (of the form returned by \code{sk_pars}), the
function returns a list of strings: a kernel family string ('k'), dimension-wise kernel
parameters (sub-list 'kp', with entries 'y' and 'x'), and a title containing the
kernel family, nugget effect, and partial sill.

When \code{pars} is a character string, the function returns it unchanged. When \code{pars}
is a vector of two character strings, it concatenates them with separator " x ".
When \code{pars} is a list of kernel parameters for a single dimension, it returns a named
list of two character strings: the kernel name (named entry 'k') and the parameter(s)
(named entry 'kp'), parenthesized, in "name = value" format where "value" is rounded
to \code{nsig} significant digits).
}
\examples{
kname = 'mat'
sk_to_string(kname)
sk_to_string(rep(kname, 2))
sk_to_string(list(k=kname))

gdim = c(10, 15)
pars = sk_pars(gdim, kname)
sk_to_string(pars)

}
\seealso{
sk_plot_pars

Other parameter managers: 
\code{\link{sk_bds}()},
\code{\link{sk_fit}()},
\code{\link{sk_kp}()},
\code{\link{sk_pars_make}()},
\code{\link{sk_pars_update}()},
\code{\link{sk_pars}()}
}
\concept{parameter managers}
\keyword{internal}
