% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmsmurf-class.R
\docType{class}
\name{glmsmurf-class}
\alias{glmsmurf-class}
\title{Class of Multi-Type Regularized GLMs Fitted Using the SMuRF Algorithm}
\value{
An object of class '\code{glmsmurf}' is a list with at least following components:
  \item{coefficients}{Coefficients of the estimated model.}
  \item{residuals}{Working residuals of the estimated model, see \code{\link[stats]{glm}}: \eqn{((y_1-\mu_1)/(d\mu/d\eta(\eta_1)), \ldots, (y_n-\mu_n)/(d\mu/d\eta(\eta_n)))}.}
  \item{fitted.values}{Fitted mean values of the estimated model \eqn{(\mu_1, \ldots, \mu_n)=(g^{-1}(\eta_1), \ldots, g^{-1}(\eta_n))} with \eqn{g^{-1}} the inverse link function.}
  \item{rank}{Numeric rank of the estimated model, i.e. the number of unique non-zero coefficients.}
  \item{family}{The used \code{\link[stats]{family}} object.}
  \item{linear.predictors}{Linear fit of the estimated model on the link scale \eqn{(\eta_1, \ldots, \eta_n)}.}
  \item{deviance}{Deviance of the estimated model: minus twice the log-likelihood, up to a constant.}
  \item{aic}{Akaike Information Criterion of the estimated model: \eqn{-2\times L + 2\times rank} with \eqn{L} the log-likelihood.}
  \item{bic}{Bayesian Information Criterion of the estimated model: \eqn{-2\times L + \ln(n^*)\times rank} with \eqn{n^*} the number of observations excluding those with weight 0.}
  \item{gcv}{Generalized Cross-Validation score of the estimated model: \eqn{deviance / (n^* \times (1 - rank / n^*)^2).}}
  \item{null.deviance}{Deviance of the null model, i.e. the model with only an intercept and offset.}
  \item{df.residual}{Residual degrees of freedom of the estimated model, i.e. the number of observations (excluding those with weight 0) minus the rank of the estimated model.}
  \item{df.null}{Residual degrees of freedom for the null model, i.e. the number of observations (excluding those with weight 0) minus the rank of the null model.}   
  \item{obj.fun}{Value of the objective function of the estimated model: minus the regularized scaled log-likelihood of the estimated model.}   
  \item{weights}{The prior weights that were initially supplied. 
                 Note that they are called \code{prior.weights} in the output of \code{\link[stats]{glm}}.}
  \item{offset}{The used offset vector.}
  \item{lambda}{The used penalty parameter: initially supplied by the user, or selected in-sample, out-of-sample or using cross-validation.}
  \item{lambda1}{The used penalty parameter for the \eqn{L_1}-penalty in Sparse (Generalized) Fused Lasso or 
                 Sparse Graph-Guided Fused Lasso is \eqn{\lambda \times \lambda_1}}
  \item{lambda2}{The used penalty parameter for the \eqn{L_2}-penalty in Group (Generalized) Fused Lasso or 
                 Group Graph-Guided Fused Lasso is \eqn{\lambda \times \lambda_2}.}
  \item{iter}{The number of iterations that are performed to fit the model.}   
  \item{converged}{An integer code indicating whether the algorithm converged successfully:
    \describe{
      \item{0}{Successful convergence.}
      \item{1}{Maximum number of iterations reached.}
      \item{2}{Two subsequent restarts were performed.}
      \item{3}{Low step size (i.e. below 1e-14).}
    }}
  \item{final.stepsize}{Final step size used in the algorithm.}
  \item{n.par.cov}{List with number of parameters to estimate per predictor (covariate).}
  \item{pen.cov}{List with penalty type per predictor (covariate).}
  \item{group.cov}{List with group of each predictor (covariate) for Group Lasso where 0 means no group.} 
  \item{refcat.cov}{List with number of the reference category in the original order of the levels of each predictor (covariate) where 0 indicates no reference category.}
  \item{control}{The used control list, see \code{\link{glmsmurf.control}}.}
Optionally, following elements are also included:
  \item{X}{The model matrix, only returned when the argument \code{x.return} in \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}} is \code{TRUE}.} 
  \item{y}{The response vector, only returned when the argument \code{y.return} in \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}} is \code{TRUE}.} 
  \item{pen.weights}{List with the vector of penalty weights per predictor (covariate), only returned when the argument \code{pen.weights.return} in \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}} is \code{TRUE}.} 
When the model is re-estimated, i.e. \code{reest = TRUE} in \code{\link{glmsmurf.control}}, 
the following components are also present:
  \item{glm.reest}{Output from the call to \code{\link[speedglm]{speedglm}} or \code{\link[stats]{glm}} to fit the re-estimated model.}
  \item{coefficients.reest}{Coefficients of the re-estimated model.}
  \item{residuals.reest}{Working residuals of the re-estimated model.}
  \item{fitted.values.reest}{Fitted mean values of the re-estimated model.}
  \item{rank.reest}{Numeric rank of the re-estimated model, i.e. the number of unique non-zero re-estimated coefficients.}
  \item{linear.predictors.reest}{Linear fit of the re-estimated model on the link scale.}
  \item{deviance.reest}{Deviance of the re-estimated model.} 
  \item{aic.reest}{AIC of the re-estimated model.}
  \item{bic.reest}{BIC of the re-estimated model.}
  \item{gcv.reest}{GCV score of the re-estimated model.}
  \item{df.residual.reest}{Residual degrees of freedom of the re-estimated model.}
  \item{obj.fun.reest}{Value of the objective function of the re-estimated model: minus the regularized scaled log-likelihood of the re-estimated model.}
  \item{X.reest}{The model matrix used in the re-estimation, only returned when the argument \code{x.return} in \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}} is \code{TRUE}.} 
When lambda is not given as input but selected in-sample, out-of-sample or using cross-validation, 
i.e. the \code{lambda} argument in \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}} is a string describing the selection method, 
the following components are also present:
  \item{lambda.method}{Method (in-sample, out-of-sample or cross-validation (possibly with the one standard error rule)) and measure (AIC, BIC, GCV score, deviance, MSE or DSS) used to select \code{lambda}.
                       E.g. \code{"is.bic"} indicates in-sample selection of lambda with the BIC as measure.}
  \item{lambda.vector}{Vector of \code{lambda} values that were considered in the selection process.}
  \item{lambda.measures}{List with for each of the relevant measures a matrix containing for each considered value of \code{lambda} (rows) 
                     the measure for the whole data (in-sample), for the validation data (out-of-sample) or per cross-validation fold (cross-validation) (columns).}
 \item{lambda.coefficients}{Matrix containing for each considered value of \code{lambda} (rows) the estimated (when \code{lambda.reest = FALSE} in \code{\link{glmsmurf.control}})
                    or re-estimated (when \code{lambda.reest = TRUE}) coefficients when selecting lambda in-sample or out-of-sample (or using cross-validation with one fold); and \code{NULL} otherwise.}
When the object is output from \code{\link{glmsmurf}}, following elements are also included:   
  \item{call}{The matched call.}
  \item{formula}{The supplied formula.}  
  \item{terms}{The \code{\link[stats]{terms}} object used.}
  \item{contrasts}{The contrasts used (when relevant).}  
  \item{xlevels}{The levels of the factors used in fitting (when relevant).}
}
\description{
The functions \code{\link{glmsmurf}} and \code{\link{glmsmurf.fit}} return objects of the S3 class '\code{glmsmurf}'
             which partially inherits from the '\code{glm}' and '\code{lm}' classes.
}
\section{S3 generics}{

Following S3 generic functions are available for an object of class "\code{glmsmurf}":
\describe{
  \item{\code{\link[smurf:coef.glmsmurf]{coef}}}{Extract coefficients of the estimated model.}
  \item{\code{\link{coef_reest}}}{Extract coefficients of the re-estimated model, when available.}
  \item{\code{\link[smurf:deviance.glmsmurf]{deviance}}}{Extract deviance of the estimated model.}
  \item{\code{\link{deviance_reest}}}{Extract deviance of the re-estimated model, when available.}
  \item{\code{\link[stats:glm.summaries]{family}}}{Extract family object.}
  \item{\code{\link[smurf:fitted.glmsmurf]{fitted}}}{Extract fitted values of the estimated model.}
  \item{\code{\link{fitted_reest}}}{Extract fitted values of the re-estimated model, when available.}   
  \item{\code{\link[smurf:plot.glmsmurf]{plot}}}{Plot coefficients of the estimated model.} 
  \item{\code{\link{plot_reest}}}{Plot coefficients of the re-estimated model, when available.} 
  \item{\code{\link{plot_lambda}}}{Plot goodness-of-fit statistics or information criteria
                                   as a function of lambda, when lambda is selected in-sample, out-of-sample or 
                                   using cross-validation.} 
  \item{\code{\link[smurf:predict.glmsmurf]{predict}}}{Obtain predictions using the estimated model.}
  \item{\code{\link{predict_reest}}}{Obtain predictions using the re-estimated model, when available.}   
  \item{\code{\link[smurf:residuals.glmsmurf]{residuals}}}{Extract residuals of the estimated model.} 
  \item{\code{\link{residuals_reest}}}{Extract residuals of the re-estimated model, when available.} 
  \item{\code{\link[smurf:summary.glmsmurf]{summary}}}{Print a summary of the estimated model, and of the re-estimated model (when available).}    
 }
}

\examples{
## See example(glmsmurf) for examples

}
\seealso{
\code{\link{glmsmurf}}, \code{\link[stats]{glm}}, \code{\link{lm}}
}
