% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{plot.matrix}
\alias{plot.matrix}
\title{Presents matrix as a heatmap}
\usage{
\method{plot}{matrix}(x, labs = c("X", "Y"), color.palette = c("default",
  "special"), main = "", ...)
}
\arguments{
\item{x}{Matrix to plot.}

\item{labs}{Vector of labels for X and Y axes.}

\item{color.palette}{Character string \code{"default"} or \code{"special"} or a function accepting one argument and returning a color palette
(for example \code{\link[grDevices]{rainbow}}).}

\item{main}{Title for the plot.}

\item{...}{Other parameters. They are currently ignored.}
}
\description{
Presents matrix as a heatmap
}
\examples{
\dontrun{

plot(matrix(rnorm(100),10,10), main = "Noise")
plot(matrix(1:100,10,10), c("Dimension 1", "Dimension 2"), main = "Value")

library(demography)
m <- log(fr.mort$rate$female[1:30, 150:160])
plot(m)
plot(m, color.palette = "special")
plot(m, color.palette = rainbow)
}
}
\author{
Alexander Dokumentov
}
